% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io-gff.R
\name{write_gff}
\alias{write_gff}
\alias{write_gff1}
\alias{write_gff2}
\alias{write_gff3}
\title{Write a GFF(123) file}
\usage{
write_gff(x, file, index = FALSE)

write_gff1(x, file, index = FALSE)

write_gff2(x, file, index = FALSE)

write_gff3(x, file, index = FALSE)
}
\arguments{
\item{x}{A GRanges object}

\item{file}{Path or connection to write to}

\item{index}{If TRUE the output file will be compressed and indexed using bgzf and
tabix.}
}
\value{
The write function returns a GFFFile object invisibly
}
\description{
This is a lightweight wrapper to the export family
of functions defined in \pkg{rtracklayer}.
}
\examples{
\dontrun{
 test_path <- system.file("tests", package = "rtracklayer")
 test_gff3 <- file.path(test_path, "genes.gff3")
 gr <- read_gff3(test_gff3)
 out_gff3 <- file.path(tempdir(), "test.gff3")
 write_gff3(gr, out_gff3)
 read_gff3(out_gff3)
}
}
\seealso{
\code{rtracklayer::\link[rtracklayer:GFFFile-class]{GFFFile()}}
}
