% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-construct.R
\name{as_ranges}
\alias{as_ranges}
\title{Coerce an Rle or RleList object to Ranges}
\usage{
as_ranges(.data)
}
\arguments{
\item{.data}{a \code{\link[=Rle]{Rle()}} or an \code{\link[=RleList]{RleList()}} object.}
}
\value{
an \code{\link[=IRanges]{IRanges()}} object if the input is an
\code{\link[=Rle]{Rle()}} object or a \code{\link[=GRanges]{GRanges()}} object for
an \code{\link[=RleList]{RleList()}} object.
}
\description{
Coerce an Rle or RleList object to Ranges
}
\details{
This function is behind \code{\link[=compute_coverage]{compute_coverage()}}.
}
\examples{
x <- S4Vectors::Rle(10:1, 1:10)
as_ranges(x)

# must have names set
y <- IRanges::RleList(chr1 = x)
as_ranges(y)

}
\seealso{
\code{S4Vectors::\link[S4Vectors:Rle-class]{Rle()}},
\code{IRanges::\link[IRanges:AtomicList]{RleList()}}
}
