% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGenes.R
\name{plotGenes}
\alias{plotGenes}
\title{Plot a gene track for a specified genomic region}
\usage{
plotGenes(
    chrom,
    chromstart = NULL,
    chromend = NULL,
    assembly = "hg38",
    fontsize = 8,
    fontcolor = c("#669fd9", "#abcc8e"),
    fill = c("#669fd9", "#abcc8e"),
    geneOrder = NULL,
    geneHighlights = NULL,
    geneBackground = "grey",
    strandLabels = TRUE,
    stroke = 0.1,
    bg = NA,
    x = NULL,
    y = NULL,
    width = NULL,
    height = unit(0.6, "inches"),
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL
)
}
\arguments{
\item{chrom}{Chromosome of region to be plotted, as a string.}

\item{chromstart}{Integer start position on chromosome to be plotted.}

\item{chromend}{Integer end position on chromosome to be plotted.}

\item{assembly}{Default genome assembly as a string or a
\link[plotgardener]{assembly} object.
Default value is \code{assembly = "hg38"}.}

\item{fontsize}{A numeric specifying text fontsize in points.
Default value is \code{fontsize = 8}.}

\item{fontcolor}{A character value or vector of length 2 indicating
the fontcolors for the plus strand and minus strand gene labels.
The first value will color the plus strand gene labels and
the second value will color the minus strand gene labels.
Default value is \code{fontcolor = c("#669fd9", "#abcc8e")}.}

\item{fill}{A character value or vector of length 2 indicating the
strand fill colors for the plus strand and minus strand plot elements.
The first value will color the plus strand plot elements and
the second label will color the minus strand plot elements.
Default value is \code{fill = c("#669fd9", "#abcc8e")}.}

\item{geneOrder}{An ordered character vector of gene names to
prioritize when labeling genes.}

\item{geneHighlights}{A two-column dataframe with a column named "gene"
containing gene names as strings to highlight and a named column "color"
containing corresponding highlight colors.}

\item{geneBackground}{If \code{geneHighlights} is given, a character
value indicating the color for genes that are not highlighted.}

\item{strandLabels}{A logical value indicating whether to include
+ and - strand labels to the left of the gene track.}

\item{stroke}{A numeric value indicating the stroke width for gene
body outlines. Default value is \code{stroke = 0.1}.}

\item{bg}{Character value indicating background color.
Default value is \code{bg = NA}.}

\item{x}{A numeric or unit object specifying genes plot x-location.}

\item{y}{A numeric, unit object, or character containing a "b"
combined with a numeric value specifying genes plot y-location.
The character value will
place the genes plot y relative to the bottom of the most recently
plotted plot according to the units of the plotgardener page.}

\item{width}{A numeric or unit object specifying genes plot width.}

\item{height}{A numeric or unit object specifying genes plot height.}

\item{just}{Justification of genes plot relative to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use if
\code{x}, \code{y}, \code{width}, or \code{height} are only given
as numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics output
should be produced. Default value is \code{draw = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}
}
\value{
Returns a \code{genes} object containing
relevant genomic region, placement, and \link[grid]{grob} information.
}
\description{
Plot a gene track for a specified genomic region
}
\details{
A gene track can be placed on a page by providing
plot placement parameters:
\preformatted{
plotGenes(chrom, chromstart = NULL, chromend = NULL,
            x, y, width, height, just = c("left", "top"),
            default.units = "inches")
}
This function can be used to quickly plot an unnannotated gene track
by ignoring plot placement parameters:
\preformatted{
plotGenes(chrom, chromstart = NULL, chromend = NULL)
}

Genomic annotation information is acquired through
\link[GenomicFeatures]{TxDb} and \link[AnnotationDbi]{OrgDb-class}
packages, as determined
through the \code{assembly} parameter. To avoid overcrowding of gene name
labels, plotted gene labels are by default prioritized according to
citation counts.
}
\examples{
## Load hg19 genomic annotation packages
library("TxDb.Hsapiens.UCSC.hg19.knownGene")
library("org.Hs.eg.db")

## Set genomic coordinates
paramssmall <- pgParams(
    chrom = "chr8",
    chromstart = 1, chromend = 3000000,
    assembly = "hg19", width = 7
)
paramsbig <- pgParams(
    chrom = "chr8",
    chromstart = 1, chromend = 146364022,
    assembly = "hg19", width = 7
)
## Set colors
cols <- c("#41B6C4", "#225EA8")

## Create page
pageCreate(width = 7.5, height = 3.5, default.units = "inches")

## Plot genes big
genesPlot <- plotGenes(
    params = paramsbig, fill = cols,
    fontcolor = cols,
    x = 0.25, y = 0.25, height = 0.75,
    just = c("left", "top"),
    default.units = "inches"
)

## Annotate genome label
annoGenomeLabel(
    plot = genesPlot, x = 0.25, y = 1.0,
    scale = "Mb", just = c("left", "top")
)

## Plot genes small
genesPlot <- plotGenes(
    params = paramssmall,
    geneHighlights = data.frame(
        "gene" = c("DLGAP2"),
        "color" = c("#225EA8")
    ),
    geneBackground = "grey",
    x = 0.25, y = 2.25, height = 0.75,
    just = c("left", "top"), default.units = "inches"
)

## Annotate genome label
annoGenomeLabel(
    plot = genesPlot, x = 0.25, y = 3.0, scale = "Mb",
    just = c("left", "top")
)

## Hide page guides
pageGuideHide()
}
\seealso{
\link[plotgardener]{assembly},
\link[plotgardener]{genomes}, \link[plotgardener]{defaultPackages}
}
