% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizeData.R
\name{organizeData}
\alias{organizeData}
\title{A function to organize a tibble into tidy format
and perform count transformations}
\usage{
organizeData(data = NULL, exclude = NULL, comp = NULL,
  comps = NULL, variables = NULL, id = NULL, beadColumn = NULL,
  dilutionColumn = NULL)
}
\arguments{
\item{data}{A tibble}

\item{exclude}{A list of columns to exclude from gather}

\item{comp}{the name of comparison column}

\item{comps}{A vector of names of the comparisons}

\item{variables}{A vector of the variables to be plotted}

\item{id}{The name of unique identifier column}

\item{beadColumn}{The column name that has total number of beads/sample}

\item{dilutionColumn}{The column name that has dilution factor for
each sample 1/x}
}
\value{
Tibble in tidy format based on columns chosen to be excluded.
Count data will be transformed if appropriate columns are present.
}
\description{
This function will organize a tibble into tidy format and perform count
transformations if appropriate columns are specified.
}
\examples{
iris \%>\% dplyr::mutate(Species = as.character(Species)) \%>\%
dplyr::group_by(Species) \%>\%
dplyr::mutate(Sample = paste0(Species, "_", dplyr::row_number()),
Sheet = "iris") \%>\%
dplyr::select(Sample, Sheet, Species, dplyr::everything()) \%>\%
plotGrouper::organizeData(data = .,
exclude = c("Sample", "Sheet", "Species"),
comp = "Species",
comps = c("setosa", "versicolor", "virginica"),
variables = "Sepal.Length",
id = "Sample",
beadColumn = "none",
dilutionColumn = "none")
}
\keyword{organizeData}
