% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gplot.R
\name{gplot}
\alias{gplot}
\title{A function to create a grouped plot and return a table grob.}
\usage{
gplot(dataset = NULL, comparison = NULL, group.by = NULL,
  levs = TRUE, val = "value", geom = c("bar", "errorbar", "point",
  "stat", "seg"), p = "p.signif", ref.group = NULL,
  p.adjust.method = "holm", comparisons = NULL, method = "t.test",
  paired = FALSE, errortype = "mean_sdl", y.lim = NULL,
  y.lab = NULL, trans.y = "identity", x.lim = c(NA, NA),
  expand.y = c(0, 0), x.lab = NULL, trans.x = "identity",
  sci = FALSE, angle.x = FALSE, levs.comps = TRUE,
  group.labs = NULL, stats = FALSE, split = TRUE, split_str = NULL,
  trim = "none", leg.pos = "top", stroke = 0.25, font_size = 9,
  size = 1, width = 0.8, dodge = 0.8, plotWidth = 30,
  plotHeight = 40, shape.groups = c(19, 21),
  color.groups = c("black", "black"), fill.groups = c("#444444", NA,
  "#A33838"))
}
\arguments{
\item{dataset}{Define your data set which should be a gathered tibble}

\item{comparison}{Specify the comparison you would like to make
(e.g., Genotype)}

\item{group.by}{Specify the variable to group by (e.g., Tissue).}

\item{levs}{Specify the order of the grouping variables}

\item{val}{Specify column name that contains values (optional)}

\item{geom}{Define the list of geoms you want to plot}

\item{p}{Specify representation of pvalue
(p.signif = astrisk representation of the raw p value;
p.format = 'p = 0.05'; 
p.adj = adjusted p-value; 
p.adj.signif = astrisk representation of the adjusted p value)}

\item{ref.group}{Specify a reference group to compare all other
comparisons to}

\item{p.adjust.method}{Method used for adjusting the pvalue}

\item{comparisons}{Specify which of the available comparisons within your
data you would like to plot}

\item{method}{Specify the statistical test to be used}

\item{paired}{Specify whether or not the statistical comparisons should be
paired}

\item{errortype}{Specify the method of statistical error to plot}

\item{y.lim}{Specify the min and max values to be used for the y-axis}

\item{y.lab}{Specify a custom y-axis label to use}

\item{trans.y}{Specify the transformation to perform on the dependent
variable}

\item{x.lim}{Specify the min and max values to be used for the x-axis}

\item{expand.y}{Specify values to expand the y-axis}

\item{x.lab}{Specify a custom x-axis label to use}

\item{trans.x}{Specify the transformation to perform on the independent
variable}

\item{sci}{Specify whether or not to display the dependent variable using
scientific notation}

\item{angle.x}{Specify whether or not to angle the x-axis text 45deg}

\item{levs.comps}{Specify the order in which to plot the comparisons}

\item{group.labs}{Specify custom labels for the independent variables}

\item{stats}{Specify whether or not to output the statistics table}

\item{split}{Specify whether or not to split the x-axis label text}

\item{split_str}{Specify the string to split the x-axis label text by; uses
regex}

\item{trim}{Specify the string to trim text from the right side of the
x-axis label text; uses regex}

\item{leg.pos}{Specify where to place the legend}

\item{stroke}{Specify the line thickness to use}

\item{font_size}{Specify the font size to use}

\item{size}{Specify the size of the points to use}

\item{width}{Specify the width of groups to be plotted}

\item{dodge}{Specify the width to dodge the comparisons by}

\item{plotWidth}{Specify the length of the x-axis in mm}

\item{plotHeight}{Specify the length of the y-axis in mm}

\item{shape.groups}{Specify the default shapes to use for the comparisons}

\item{color.groups}{Specify the default colors to use for the comparisons}

\item{fill.groups}{Specify the default fills to use for the comparisons}
}
\value{
Table grob of the plot
}
\description{
This function allows you to create a grouped plot and return a table grob.
It takes a tidy dataset containing sample replicate values for at least one
variable, a column organizing each replicate into the proper comparison
group, and a column that groups the variables to be plotted. Additional
arguments allow for the re-ordering of the variables and the
comparisons being ploted, selection of the type of graph to display (e.g.,
bar graph, boxplot, violin plot, points, statistical summary, etc...), as
well as other aesthetics of the plot.
}
\examples{
iris \%>\% dplyr::mutate(Species = as.character(Species)) \%>\%
dplyr::group_by(Species) \%>\%
dplyr::mutate(Sample = paste0(Species, "_", dplyr::row_number()),
Sheet = "iris") \%>\%
dplyr::select(Sample, Sheet, Species, dplyr::everything()) \%>\%
tidyr::gather(variable, value, -c(Sample, Sheet, Species)) \%>\%
dplyr::filter(variable == "Sepal.Length") \%>\%
plotGrouper::gplot(
comparison = "Species",
group.by = "variable",
shape.groups = c(19,21,17),
color.groups = c(rep("black",3)),
fill.groups = c("black","#E016BE", "#1243C9")) \%>\%
gridExtra::grid.arrange()
}
