% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotElapsed.R
\name{plotElapsed}
\alias{plotElapsed}
\title{plotElapsed}
\usage{
plotElapsed(
  res,
  steps = names(res$elapsed$stepwise),
  agg.by,
  agg.fn = mean,
  width = 0.9,
  split.datasets = TRUE,
  return.df = FALSE
)
}
\arguments{
\item{res}{Aggregated pipeline results}

\item{steps}{The step(s) to plot (default all)}

\item{agg.by}{The parameters by which to aggregate (set to FALSE to disable 
aggregation)}

\item{agg.fn}{Aggregation function}

\item{width}{Width of the bar; default 0.9, use 1 to remove the gaps}

\item{split.datasets}{Logical; whether to split the datasets into facets}

\item{return.df}{Logical; whether to return the data.frame instead of plot}
}
\value{
A ggplot, or a data.frame if `return.df=TRUE`
}
\description{
Plot total elapsed time per run, split per step.
}
\examples{
data("exampleResults", package="pipeComp")
plotElapsed(exampleResults, agg.by = "norm")

}
