% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneSetSummary.R
\name{geneSetSummary}
\alias{geneSetSummary}
\title{Gene set summary}
\usage{
geneSetSummary(gsaRes, geneSet)
}
\arguments{
\item{gsaRes}{an object of class \code{GSAres}, as returned from
\code{runGSA()}.}

\item{geneSet}{a character string giving the name of a gene-set.}
}
\value{
A list with the elements \code{name}, containing the gene-set name,
\code{geneLevelStats}, containing the gene-level statistics of the member
genes, \code{directions}, containing the directions of the member genes, and
\code{stats}, a table of the gene set statistics and p-values.
}
\description{
Returns a summary of the statistics and gene members of a given gene set in
a \code{GSAres} object.
}
\details{
This function can be used to access information on specific gene sets of
interest. The same results are available for all gene sets using
\code{\link{GSAsummaryTable}}.
}
\examples{

   # Load example input data to GSA:
   data("gsa_input")
   
   # Load gene set collection:
   gsc <- loadGSC(gsa_input$gsc)
      
   # Run gene set analysis:
   gsares <- runGSA(geneLevelStats=gsa_input$pvals , directions=gsa_input$directions, 
                    gsc=gsc, nPerm=500)
      
   # Get info on a specific gene set:
   geneSetSummary(gsares,"s1")

}
\seealso{
\pkg{\link{piano}}, \code{\link{runGSA}},
\code{\link{GSAsummaryTable}}
}
\author{
Leif Varemo \email{varemo@chalmers.se} and Intawat Nookaew
\email{intawat@chalmers.se}
}
