% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clvm.R
\name{clvm}
\alias{clvm}
\title{Fit a CLVM Model}
\usage{
clvm(y, x, maxiter = 10000, elbo_tol = 1e-05, thin = 1, verbose = TRUE,
  z_init = 1, tau_q = 1, tau_mu = 1, tau_c = 1, a = 2, b = 2,
  tau_alpha = 1, a_beta = 10, b_beta = 1, q = rep(0, nrow(y)),
  model_mu = FALSE, scale_y = TRUE)
}
\arguments{
\item{y}{A N-by-G (dynamic) input matrix}

\item{x}{A N-by-P (static) input matrix}

\item{maxiter}{Maximum number of CAVI iterations}

\item{elbo_tol}{The (percent) change in the ELBO below which it is 
considered converged}

\item{thin}{The number of iterations to wait each time before
re-calculating the elbo}

\item{verbose}{Print convergence messages}

\item{z_init}{The initialisation of the latent trajectory. Should be one of
\enumerate{
\item A positive integer describing which principal component of the data 
should be used for initialisation (default 1), \emph{or}
\item A numeric vector of length number of samples to be used directly 
for initialisation, \emph{or}
\item The text character \code{"random"}, for random initialisation from 
a standard normal distribution.
}}

\item{tau_q}{Hyperparameter tau_q}

\item{tau_mu}{Hyperparameter tau_mu}

\item{tau_c}{Hyperparameter tau_c}

\item{a}{Hyperparameter a}

\item{b}{Hyperparameter b}

\item{tau_alpha}{Hyperparameter tau_alpha}

\item{a_beta}{Hyperparameter a_beta}

\item{b_beta}{Hyperparameter b_beta}

\item{q}{Priors on the latent variables}

\item{model_mu}{Logical - should a gene-specific intercept term be modelled?}

\item{scale_y}{Logical - should the expression matrix be centre scaled?}
}
\value{
A list whose entries correspond to the converged values of the
variational parameters along with the ELBO.
}
\description{
Fit a covariate latent variable model using coordinate ascent
variational inference.
}
\examples{
sim <- simulate_phenopath()
fit <- clvm(sim$y, matrix(sim$x))


}
