% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/reading-writing.R
\name{writing}
\alias{writing}
\alias{writing,MultiAssayExperiment-method}
\alias{writing,SummarizedExperiment-method}
\alias{writing,MultiDataSet-method}
\alias{writing,ExpressionSet-method}
\title{Exporting a SummarizedExperiment (or MultiAssayExperiment) instance into
(subfolders with) the 3 tabulated files 'dataMatrix.tsv',
sampleMetadata.tsv', 'variableMetadata.tsv'}
\usage{
writing(
  x,
  dir.c,
  prefix.c = "",
  files.ls = NULL,
  overwrite.l = FALSE,
  metadata.l = FALSE,
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{writing}{MultiAssayExperiment}(
  x,
  dir.c,
  prefix.c = "",
  files.ls = NULL,
  overwrite.l = FALSE,
  metadata.l = FALSE,
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{writing}{SummarizedExperiment}(
  x,
  dir.c,
  prefix.c = "",
  files.ls = NULL,
  overwrite.l = FALSE,
  metadata.l = FALSE,
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{writing}{MultiDataSet}(
  x,
  dir.c,
  prefix.c = "",
  files.ls = NULL,
  overwrite.l = FALSE,
  metadata.l = FALSE,
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{writing}{ExpressionSet}(
  x,
  dir.c,
  prefix.c = "",
  files.ls = NULL,
  overwrite.l = FALSE,
  metadata.l = FALSE,
  report.c = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{x}{An S4 object of class \code{SummarizedExperiment} or
\code{MultiAssayExperiment} (\code{ExpressionSet} and \code{MultiDataSet}
are still supported)}

\item{dir.c}{character(1): directory where each dataset should be written}

\item{prefix.c}{character(1): prefix to be used (followed by '_') in the
'dataMatrix.tsv', 'sampleMetadata.tsv', and 'variableMetadata.tsv' file names}

\item{files.ls}{list: alternatively to the dir.c argument, the full names of
the files can be provided as a list}

\item{overwrite.l}{logical(1): should existing files be overwritten?}

\item{metadata.l}{logical(1): should the metadata be saved (as an additional
.rds file)?}

\item{report.c}{character(1): File name with '.txt' extension for the printed
results (call to sink()'); if 'interactive' (default), messages will be
printed on the screen; if 'none', no verbose will be generated}
}
\value{
No object returned.
}
\description{
Note that the \code{dataMatrix} is transposed before export (e.g., the
samples are written column wise in the 'dataMatrix.tsv' exported file).
}
\examples{
metabo.se <- reading(system.file("extdata/prometis/metabo",
                     package = "phenomis"))
\donttest{
writing(metabo.se, dir.c = file.path(getwd(), "metabo"))
}
# MultiAssayExperiment
prometis.mae <- reading(system.file("extdata/prometis",package="phenomis"))
\donttest{
writing(prometis.mae, dir.c = file.path(getwd(), "prometis"))
# alternatively
writing(prometis.mae,
         dir.c = NA,
         files.ls = list(metabo = list(dataMatrix = file.path(getwd(),
                                             "met_dataMatrix.tsv"),
                                      sampleMetadata = file.path(getwd(),
                                      "met_sampleMetadata.tsv"),
                                      variableMetadata = file.path(getwd(),
                                      "met_variableMetadata.tsv")),
                        proteo = list(dataMatrix = file.path(getwd(),
                                      "pro_dataMatrix.tsv"),
                                      sampleMetadata = file.path(getwd(),
                                      "pro_sampleMetadata.tsv"),
                                      variableMetadata = file.path(getwd(),
                                      "pro_variableMetadata.tsv"))))
}
}
