% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_plots.R
\name{gg_barplot}
\alias{gg_barplot}
\title{Barplot with ggplot2}
\usage{
gg_barplot(
  data.mn,
  log10.l = FALSE,
  ylim.vn = c(NA, NA),
  title.c = "",
  xlab.c = "",
  ylab.c = "",
  row_levels.vc = NA,
  col_levels.vc = NA,
  palette.vc = "Set1",
  theme.c = c("default", "bw", "classic", "dark", "gray", "linedraw", "light", "minimal",
    "void")[3],
  flip.l = FALSE,
  legend_position.c = c("none", "bottom", "left", "top", "right")[2],
  cex_axis.i = 18,
  cex_bar.i = 10,
  cex_title.i = 28,
  bar_just.n = 0.9,
  figure.c = c("interactive", "my_barplot.pdf", "none")[1]
)
}
\arguments{
\item{data.mn}{Matrix of numerics: values to be barplotted}

\item{log10.l}{logical(1): should the intensities be log10 transformed?}

\item{ylim.vn}{numeric(2): minimum and maximum values for the bars}

\item{title.c}{Character: plot title}

\item{xlab.c}{Character: x label}

\item{ylab.c}{Character: y label}

\item{row_levels.vc}{Vector of characters: levels of rownames (default: NA:
alphabetical order will be used)}

\item{col_levels.vc}{Vector of characters: levels of colnames (default: NA:
alphabetical order will be used)}

\item{palette.vc}{Character: either the name of an RColorBrewer palette
(default: 'Set1'; 'Paired' can be useful for parallel plotting) or a vector
manually defining the colors}

\item{theme.c}{character(1): name of the ggplot theme}

\item{flip.l}{logical(1): should the barplot be flipped (default: FALSE)}

\item{legend_position.c}{character(1): position of the legend: either "none",
"bottom" (default), "left", "top", "right"}

\item{cex_axis.i}{Integer: size of axis text (default: 18)}

\item{cex_bar.i}{Integer: size of bar value text (default: 10)}

\item{cex_title.i}{Integer: size of title text (default: 28)}

\item{bar_just.n}{Numeric: adjustment of bar value text (default : 0.9)}

\item{figure.c}{Character: either 'interactive' for interactive display,
'my_barplot.pdf' for figure saving (only the extension matters), or 'none'
to prevent plotting}
}
\value{
invisible ggplot2 object
}
\description{
Barplot with ggplot2
}
\examples{
prometis.mae <- reading(system.file("extdata/prometis", package = "phenomis"))
dims.mn <- vapply(names(prometis.mae),
                  function(set.c) { dim(prometis.mae[[set.c]])},
                  FUN.VALUE = integer(2))
dims.mn <- t(dims.mn)
colnames(dims.mn) <- c("features", "samples")
gg_barplot(dims.mn, title.c = "ProMetIS data",
           row_levels = c("proteo", "metabo"),
           col_levels = c("samples", "features"),
           ylim.vn = c(NA, 110),
           bar_just = -0.25,
           cex_bar.i = 6,
           cex_title.i = 15)
}
