% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/clustering.R
\name{clustering}
\alias{clustering}
\alias{clustering,MultiAssayExperiment-method}
\alias{clustering,SummarizedExperiment-method}
\alias{clustering,MultiDataSet-method}
\alias{clustering,ExpressionSet-method}
\title{clustering}
\usage{
clustering(
  x,
  dissym.c = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski",
    "1-cor", "1-abs(cor)")[7],
  correl.c = c("pearson", "kendall", "spearman")[1],
  agglo.c = c("ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median",
    "centroid")[2],
  clusters.vi = c(2, 2),
  cex.vn = c(1, 1),
  palette.c = c("blueOrangeRed", "redBlackGreen")[1],
  scale_plot.l = TRUE,
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{clustering}{MultiAssayExperiment}(
  x,
  dissym.c = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski",
    "1-cor", "1-abs(cor)")[7],
  correl.c = c("pearson", "kendall", "spearman")[1],
  agglo.c = c("ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median",
    "centroid")[2],
  clusters.vi = c(2, 2),
  cex.vn = c(1, 1),
  palette.c = c("blueOrangeRed", "redBlackGreen")[1],
  scale_plot.l = TRUE,
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{clustering}{SummarizedExperiment}(
  x,
  dissym.c = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski",
    "1-cor", "1-abs(cor)")[7],
  correl.c = c("pearson", "kendall", "spearman")[1],
  agglo.c = c("ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median",
    "centroid")[2],
  clusters.vi = c(2, 2),
  cex.vn = c(1, 1),
  palette.c = c("blueOrangeRed", "redBlackGreen")[1],
  scale_plot.l = TRUE,
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{clustering}{MultiDataSet}(
  x,
  dissym.c = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski",
    "1-cor", "1-abs(cor)")[7],
  correl.c = c("pearson", "kendall", "spearman")[1],
  agglo.c = c("ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median",
    "centroid")[2],
  clusters.vi = c(2, 2),
  cex.vn = c(1, 1),
  palette.c = c("blueOrangeRed", "redBlackGreen")[1],
  scale_plot.l = TRUE,
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{clustering}{ExpressionSet}(
  x,
  dissym.c = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski",
    "1-cor", "1-abs(cor)")[7],
  correl.c = c("pearson", "kendall", "spearman")[1],
  agglo.c = c("ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median",
    "centroid")[2],
  clusters.vi = c(2, 2),
  cex.vn = c(1, 1),
  palette.c = c("blueOrangeRed", "redBlackGreen")[1],
  scale_plot.l = TRUE,
  title.c = NA,
  figure.c = c("none", "interactive", "myfile.pdf")[2],
  report.c = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{x}{An S4 object of class \code{SummarizedExperiment}
or \code{MultiAssayExperiment} (\code{ExpressionSet} and \code{MultiDataSet}
are still supported)}

\item{dissym.c}{character(1): dissymilarity to be used in the hierarchical
clustering (as provided by the hclust package)}

\item{correl.c}{character(1): correlation coefficient (in case
'1-cor' or '1-abs(cor)' are selected as dissymilarity)}

\item{agglo.c}{character(1): agglomeration method}

\item{clusters.vi}{integer(2): number of sample and variable
clusters, respectively; the default values (2) are only provided as starting
guess (e.g. in case of two groups of samples)}

\item{cex.vn}{numeric(2) [Plot parameter]; size of the sample and
variable labels}

\item{palette.c}{character(1) [Plot parameter]: color palette}

\item{scale_plot.l}{logical(1) [Plot parameter]: scaling (mean-centering and
unit variance scaling) to enhance contrast (for plotting only)}

\item{title.c}{character(1) [Plot parameter]: Graphic the subtitle}

\item{figure.c}{character(1): File name with '.pdf' extension for the figure;
if 'interactive' (default), figures will be displayed interactively;
if 'none', no figure will be generated}

\item{report.c}{character(1): File name with '.txt' extension for the printed
results (call to sink()'); if 'interactive' (default), messages will be
printed on the screen; if 'none', no verbose will be generated}
}
\value{
\code{SummarizedExperiment} or \code{MultiAssayExperiment}
(or \code{ExpressionSet} and \code{MultiDataSet}) including columns
indicating the clusters in rowData and colData if clusters.vi' has been
specified
}
\description{
Hierarchical clustering of both samples and variables
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine.se <- correcting(sacurine.se)
sacurine.se <- sacurine.se[, colData(sacurine.se)[, "sampleType"] != "pool"]
sacurine.se <- transforming(sacurine.se)
sacurine.se <- sacurine.se[, colnames(sacurine.se) != "HU_neg_096_b2"]
sacurine.se <- clustering(sacurine.se)
utils::head(rowData(sacurine.se))

# MultiAssayExperiment

prometis.mae <- reading(system.file("extdata/prometis", package="phenomis"))
prometis.mae <- clustering(prometis.mae)
}
