% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCountsFromH5file.R
\name{loadCountsFromH5FileHSDS}
\alias{loadCountsFromH5FileHSDS}
\title{Load count matrix from remote HDF5-file}
\usage{
loadCountsFromH5FileHSDS(
  es,
  url = "https://alserglab.wustl.edu/hsds/?domain=/counts",
  file,
  sampleIndexes = NULL
)
}
\arguments{
\item{es, }{containing ExpressionSet loaded from GEO. Contains empty expression matrix.}

\item{url, }{containing url of the server and root domain.}

\item{file, }{containing name of the file (relative to the root domain)}

\item{sampleIndexes, }{containing sample indexes list}
}
\value{
ExpressionSet object with loaded count matrix
}
\description{
Load count matrix from remote HDF5-file
}
\examples{
ess <- GEOquery::getGEO("GSE53053")
es <- ess[[1]]
url <- 'https://alserglab.wustl.edu/hsds/?domain=/counts'
file <- "/dee2/mmusculus_star_matrix_20240409.h5"
es <- loadCountsFromH5FileHSDS(es, url, file)
}
