% Generated by roxygen2 (4.0.0): do not edit by hand
\name{peptideSet-methods}
\alias{[,peptideSet,ANY,ANY,ANY-method}
\alias{clade}
\alias{clade,GRanges-method}
\alias{clade,peptideSet-method}
\alias{clade-methods}
\alias{end,peptideSet-method}
\alias{featureID}
\alias{featureID,peptideSet-method}
\alias{featureID-method}
\alias{pepZscore}
\alias{pepZscore,GRanges-method}
\alias{pepZscore,peptideSet-method}
\alias{pepZscore-method}
\alias{pepZscore<-}
\alias{pepZscore<-,GRanges,data.frame-method}
\alias{pepZscore<-,peptideSet,data.frame-method}
\alias{peptide}
\alias{peptide,peptideSet-method}
\alias{peptide-method}
\alias{peptide<-}
\alias{peptide<-,peptideSet,character-method}
\alias{peptideSet-methods}
\alias{position}
\alias{position,peptideSet-method}
\alias{position-method}
\alias{ranges,peptideSet-method}
\alias{ranges<-,peptideSet-method}
\alias{show,peptideSet-method}
\alias{start,peptideSet-method}
\alias{subset,peptideSet-method}
\alias{summary,peptideSet-method}
\alias{values,peptideSet-method}
\alias{width,peptideSet-method}
\title{peptideSet methods}
\description{
Methods for handling peptideSet objects
}
\section{Accessors}{

\describe{
 \item{\code{nrow(x)}:}{The number of peptides in x.}
 \item{\code{ncol(x)}:}{The number of samples in x.}
 \item{\code{start(x)}:}{Get the starts of the peptides.}
 \item{\code{end(x)}:}{Get the ends of the peptides.}
 \item{\code{width(x)}:}{Get the widths of the peptides.}
 \item{\code{position(x)}:}{Get the coordinates of the central amino-acid of
 each peptide, given by: \code{round((start(x) + end(x))/2)}.}
 \item{\code{ranges(x)}:}{Returns a \code{GRanges} object that contains
 the annotations for the peptides.}
 \item{\code{ranges(x)<- value}}{Set annotations for the peptides.}
 \item{\code{values(x)}:}{Returns a \code{SplitDataFrameList}. Accessor for the
 values of the featureRange slot.}
 \item{\code{clade(x)}:}{If available, returns the clade information for each
 peptide as a \code{matrix}.}
 \item{\code{peptide(x)}:}{Get the sequence of the peptides.}
 \item{\code{peptide(x) <- value}}{Set the sequence of the peptides.}
 \item{\code{featureID(x)}:}{Get the ID of the peptides.}
 \item{\code{pepZscore(x)}:}{If available, returns a \code{matrix} of the zScores
 for each peptide.}
 \item{\code{pepZscore(x) <- value}}{Set the zScores for each peptide}
}
}

\section{Display}{

\describe{
 \item{\code{show(object)}:}{Display a peptideSet object.}
 \item{\code{summary(object)}:}{Summarize a peptideSet object.}
}
}

\section{Subset}{

\describe{
 \item{\code{x[i, j]}:}{Subset x by peptides (i), or samples (j).}
 \item{\code{subset(x, subset, drop=FALSE)}:}{Subset x given an expression 'subset'.}
}
}

