% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeds.R
\name{makeExampleDESeqDataSet_multifac}
\alias{makeExampleDESeqDataSet_multifac}
\title{Make a simulated DESeqDataSet for two or more experimental factors}
\usage{
makeExampleDESeqDataSet_multifac(
  n = 1000,
  m = 12,
  betaSD_condition = 1,
  betaSD_tissue = 3,
  interceptMean = 4,
  interceptSD = 2,
  dispMeanRel = function(x) 4/x + 0.1,
  sizeFactors = rep(1, m)
)
}
\arguments{
\item{n}{number of rows (genes)}

\item{m}{number of columns (samples)}

\item{betaSD_condition}{the standard deviation for condition betas, i.e. beta ~ N(0,betaSD)}

\item{betaSD_tissue}{the standard deviation for tissue betas, i.e. beta ~ N(0,betaSD)}

\item{interceptMean}{the mean of the intercept betas (log2 scale)}

\item{interceptSD}{the standard deviation of the intercept betas (log2 scale)}

\item{dispMeanRel}{a function specifying the relationship of the dispersions on
\code{2^trueIntercept}}

\item{sizeFactors}{multiplicative factors for each sample}
}
\value{
a \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} with true dispersion,
intercept for two factors (condition and tissue) and beta values in the
metadata columns.  Note that the true betas are provided on the log2 scale.
}
\description{
Constructs a simulated dataset of Negative Binomial data from different conditions.
The fold changes between the conditions can be adjusted with the \code{betaSD_condition}
and the \code{betaSD_tissue} arguments.
}
\details{
This function is designed and inspired following the proposal of
\code{\link[DESeq2:makeExampleDESeqDataSet]{DESeq2::makeExampleDESeqDataSet()}} from the \code{DESeq2} package. Credits are given
to Mike Love for the nice initial implementation
}
\examples{
dds <- makeExampleDESeqDataSet_multifac(betaSD_condition = 3, betaSD_tissue = 1)
dds
dds2 <- makeExampleDESeqDataSet_multifac(betaSD_condition = 1, betaSD_tissue = 4)
dds2

}
