% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_explore.R
\name{geneprofiler}
\alias{geneprofiler}
\title{Extract and plot the expression profile of genes}
\usage{
geneprofiler(se, genelist = NULL, intgroup = "condition", plotZ = FALSE)
}
\arguments{
\item{se}{A \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} object, or a
\code{\link[DESeq2:DESeqTransform]{DESeq2::DESeqTransform()}} object.}

\item{genelist}{An array of characters, including the names of the genes of
interest of which the profile is to be plotted}

\item{intgroup}{A factor, needs to be in the \code{colnames} of \code{colData(se)}}

\item{plotZ}{Logical, whether to plot the scaled expression values. Defaults to
\code{FALSE}}
}
\value{
A plot of the expression profile for the genes
}
\description{
Extract and plot the expression profile of genes
}
\examples{
dds <- makeExampleDESeqDataSet_multifac(betaSD_condition = 3, betaSD_tissue = 1)
rlt <- DESeq2::rlogTransformation(dds)
geneprofiler(rlt, paste0("gene", sample(1:1000, 20)))
geneprofiler(rlt, paste0("gene", sample(1:1000, 20)), plotZ = TRUE)
}
