% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superPC_model_train.R
\name{superpc.train}
\alias{superpc.train}
\title{Train a supervised PCA model}
\usage{
superpc.train(
  data,
  type = c("survival", "regression", "categorical"),
  s0.perc = NULL
)
}
\arguments{
\item{data}{A list of test data:
\itemize{
  \item{\code{x} : }{A "tall" pathway data frame (\eqn{p_{path} \times N}).}
  \item{\code{y} : }{A response vector corresponding to \code{type}.}
  \item{\code{censoring.status} : }{If \code{type = "survival"}, the
     censoring indicator (\eqn{1 - } the observed event indicator. Otherwise,
     \code{NULL}.}
  \item{\code{featurenames} : }{A character vector of the measured -Omes in
    \code{x}.}
 }}

\item{type}{What model relates \code{y} and \code{x}? Options are
\code{"survival"}, \code{"regression"}, or \code{"categorical"}.}

\item{s0.perc}{A stabilization parameter on the interval \eqn{[0,1]}. This is
an internal argument to each of the called functions. The default value is
\code{NULL} to ensure an appropriate value is determined internally.}
}
\value{
A list containing:
\itemize{
  \item{\code{feature.scores} : }{The scaled \eqn{p}-dimensional score
     vector: each value has been divided by its respective standard deviation
     plus epsilon (governed by \code{s0.perc}). \code{NA} values returned by
     the logistic model are replaced with 0.}
  \item{\code{type} : }{The argument for \code{type}.}
  \item{\code{s0.perc} : }{The user-supplied value of \code{s0.perc}, or the
    internally-calculated default value from the chosen model.}
  \item{\code{call} : }{The output of \code{\link{match.call}} for the user-
     supplied function arguments.}
}
}
\description{
Computes feature scores for \eqn{p_{path}} features of a pathway
   via a linear model fit.
}
\details{
This function is a \code{\link{switch}} call to
   \code{\link{coxTrain_fun}} (for \code{type = "survival"}),
   \code{\link{olsTrain_fun}} (for \code{type = "regression"}), or
   \code{\link{glmTrain_fun}} (for \code{type = "categorical"}).
}
\examples{
  # DO NOT CALL THIS FUNCTION DIRECTLY.
  # Use SuperPCA_pVals() instead
  
\dontrun{
  data("colon_pathwayCollection")
  data("colonSurv_df")
  
  colon_OmicsSurv <- CreateOmics(
    assayData_df = colonSurv_df[,-(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, 1:3],
    respType = "surv"
  )
  
  asthmaGenes_char <-
    getTrimPathwayCollection(colon_OmicsSurv)[["KEGG_ASTHMA"]]$IDs
    
  data_ls <- list(
    x = t(getAssay(colon_OmicsSurv))[asthmaGenes_char, ],
    y = getEventTime(colon_OmicsSurv),
    censoring.status = getEvent(colon_OmicsSurv),
    featurenames = asthmaGenes_char
  )
  
  superpc.train(
    data = data_ls,
    type = "surv"
  )
}
  
}
\seealso{
\code{\link{superpc.st}}; \code{\link{SuperPCA_pVals}}
}
\keyword{internal}
