% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printClass_Omics_All.R
\name{show,OmicsPathway-method}
\alias{show,OmicsPathway-method}
\title{Display the Summary of an \code{Omics*}-class Object.}
\usage{
\S4method{show}{OmicsPathway}(object)
}
\arguments{
\item{object}{An object inheriting the super-class \code{OmicsPathway}. This
class includes objects of class \code{OmicsSurv}, \code{OmicsReg}, or
\code{OmicsCateg}.}
}
\value{
A copy of \code{object}, returned invisibly (with the
   \code{\link{invisible}} function).
}
\description{
The display method for objects of class \code{OmicsPathway},
   \code{OmicsSurv}, \code{OmicsReg}, or \code{OmicsCateg}.
}
\details{
S4 objects print to the screen via the \code{\link[methods]{show}}
   function. This function sets a \code{show} method for \code{OmicsPathway}
   objects.
}
\examples{
  ###  Load the Example Data  ###
  data("colonSurv_df")
  data("colon_pathwayCollection")

  ###  Create an OmicsSurv Object  ###
  colon_OmicsSurv <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, 1:3],
    respType = "surv"
  )

  ###  Print / Show  ###
  colon_OmicsSurv

}
\keyword{internal}
