% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessClass_OmicsPath.R
\name{SubsetOmicsPath}
\alias{SubsetOmicsPath}
\alias{getAssay}
\alias{getAssay<-}
\alias{getSampleIDs}
\alias{getSampleIDs<-}
\alias{getPathwayCollection}
\alias{getPathwayCollection<-}
\alias{getTrimPathwayCollection}
\alias{getAssay,OmicsPathway-method}
\alias{getAssay<-,OmicsPathway-method}
\alias{getSampleIDs,OmicsPathway-method}
\alias{getSampleIDs<-,OmicsPathway-method}
\alias{getPathwayCollection,OmicsPathway-method}
\alias{getPathwayCollection<-,OmicsPathway-method}
\alias{getTrimPathwayCollection,OmicsPathway-method}
\title{Access and Edit Assay or \code{pathwayCollection} Values in \code{Omics*}
   Objects}
\usage{
getAssay(object, ...)

getAssay(object) <- value

getSampleIDs(object, ...)

getSampleIDs(object) <- value

getPathwayCollection(object, ...)

getPathwayCollection(object) <- value

getTrimPathwayCollection(object, ...)

\S4method{getAssay}{OmicsPathway}(object, ...)

\S4method{getAssay}{OmicsPathway}(object) <- value

\S4method{getSampleIDs}{OmicsPathway}(object, ...)

\S4method{getSampleIDs}{OmicsPathway}(object) <- value

\S4method{getPathwayCollection}{OmicsPathway}(object, ...)

\S4method{getPathwayCollection}{OmicsPathway}(object) <- value

\S4method{getTrimPathwayCollection}{OmicsPathway}(object, ...)
}
\arguments{
\item{object}{An object of or extending \code{\link{OmicsPathway-class}}:
that class, \code{\link{OmicsSurv-class}}, \code{\link{OmicsReg-class}},
or \code{\link{OmicsCateg-class}}.}

\item{...}{Dots for additional internal arguments (currently unused).}

\item{value}{The replacement object to be assigned to the specified slot.}
}
\value{
The "get" functions return the objects in the slots specified:
   \code{getAssay} returns the \code{assayData_df} data frame object,
   \code{getSampleIDs} returns the \code{sampleIDs_char} character vector,
   \code{getPathwayCollection} returns the \code{pathwayCollection} list
   object, and \code{getTrimPathwayCollection} returns the
   \code{trimPathwayCollection}. These functions can extract these values
   from any valid \code{OmicsPathway}, \code{OmicsSurv}, \code{OmicsReg}, or
   \code{OmicsCateg} object.

   The "set" functions enable the user to edit or replace objects in the
   \code{assayData_df}, \code{sampleIDs_char}, or \code{pathwayCollection}
   slots for any \code{OmicsPathway}, \code{OmicsSurv}, \code{OmicsReg}, or
   \code{OmicsCateg} objects, provided that the new values do not violate
   the validity checks of their respective objects. Because the slot for
   \code{trimPathwayCollection} is filled upon object creation, and to ensure
   that this pathway collection is "clean", there is no "set" function for
   the trimmed pathway collection slot. Instead, users can update the pathway
   collection, and the trimmed pathway collection will be updated
   automatically. See "Details" for more information on the "set" functions.
}
\description{
"Get" or "Set" the values of the \code{assayData_df},
   \code{sampleIDs_char}, or \code{pathwayCollection} slots of an object of
   class \code{OmicsPathway} or a class that extends this class
   (\code{OmicsSurv}, \code{OmicsReg}, or \code{OmicsCateg}).
}
\details{
These functions can be useful to set or extract the assay data or
   pathways list from an \code{Omics*}-class object. However, we recommend
   that users simply create a new, valid \code{Omics*} object instead of
   modifying an existing one. The validity of edited objects is checked with
   the \code{\link{ValidOmicsSurv}}, \code{\link{ValidOmicsCateg}}, or
   \code{\link{ValidOmicsReg}} functions.

   Further, because the \code{pathwayPCA} methods require a cleaned (trimmed)
   pathway collection, the \code{trimPathwayCollection} slot is read-only.
   Users may only edit this slot by updating the pathway collection provided
   to the \code{pathwayCollection} slot. Despite this functionality, we
   \strong{strongly} recommend that users create a new object with the
   updated pathway collection, rather than attempting to overwrite the slots
   within an existing object. See \code{\link{IntersectOmicsPwyCollct}} for
   details on trimmed pathway collection.
}
\examples{
  data("colonSurv_df")
  data("colon_pathwayCollection")

  colon_Omics <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection
  )

  getAssay(colon_Omics)
  getPathwayCollection(colon_Omics)

}
\seealso{
\code{\link{CreateOmics}}
}
