% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superPC_model_CoxPH.R
\name{coxTrain_fun}
\alias{coxTrain_fun}
\title{Train Cox Proportional Hazards model for supervised PCA}
\usage{
coxTrain_fun(x, y, censoring.status, s0.perc = NULL)
}
\arguments{
\item{x}{A "tall" pathway data frame (\eqn{p \times n}).}

\item{y}{A response vector of follow-up / event times.}

\item{censoring.status}{A censoring vector.}

\item{s0.perc}{A stabilization parameter. This is an optional argument to
each of the functions called internally. Defaults to \code{NULL}.}
}
\value{
A list containing:
\itemize{
  \item{\code{tt} : }{The scaled p-dimensional score vector: each value has
     been divided by the respective standard deviation plus the \code{fudge}
     value.}
  \item{\code{numer} : }{The original p-dimensional score vector. From the
     internal \code{.coxscor} function.}
  \item{\code{sd} : }{The standard deviations of the scores. From the
     internal \code{.coxvar} function.}
  \item{\code{fudge} : }{A regularization scalar added to the standard
     deviation. If \code{s0.perc} is supplied,
     \code{fudge = quantile(sd, s0.perc)}.}
}
}
\description{
Main and utility functions for training the Cox PH model.
}
\details{
See \url{https://web.stanford.edu/~hastie/Papers/spca_JASA.pdf},
   Section 5, for a description of Supervised PCA applied to survival data.
   The internal utility functions defined in this file (\code{.coxscor},
   \code{.coxvar}, and \code{.coxstuff}) are not called anywhere else, other
   than in the \code{coxTrain_fun} function itself. Therefore, we do not
   document these functions.

   NOTE: No missing values allowed.
}
\examples{
  # DO NOT CALL THIS FUNCTION DIRECTLY.
  # Use SuperPCA_pVals() instead
  
\dontrun{
  p <- 500
  n <- 50

  x_mat <- matrix(rnorm(n * p), nrow = p, ncol = n)
  x_df <- data.frame(x_mat)
  time_int <- rpois(n, lambda = 365 * 2)
  obs_logi <- sample(
    c(FALSE, TRUE),
    size = n,
    replace = TRUE,
    prob = c(0.2, 0.8)
  )

  coxTrain_fun(
    x = x_df,
    y = time_int,
    censoring.status = !obs_logi
  )
}
  
}
\keyword{internal}
