% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessClass_pathwayCollection_which.R
\name{WhichPathways}
\alias{WhichPathways}
\title{Filter and Subset a \code{pathwayCollection}-class Object by Symbol.}
\usage{
WhichPathways(x, symbols_char, ...)
}
\arguments{
\item{x}{An object of class \code{pathwayCollection}.}

\item{symbols_char}{A character vector or scalar of gene symbols or regions}

\item{...}{Additional arguments passed to the \code{\link{Contains}} function}
}
\value{
An object of class \code{pathwayCollection}, but containing only the
   sets which contain the symbols supplied to \code{symbols_char}. If no sets
   are found to contain the symbols supplied, this function returns
   \code{NULL} and prints a warning.
}
\description{
The filter-subset method for pathways lists as returned by the
   \code{\link{read_gmt}} function. This function returns the subset of 
   pathways which contain the set of symbols requested
}
\details{
This function finds the index of each set that contains the symbols
   supplied, then returns those sets as a new \code{pathwayCollection}
   object. Find pathways that contain geneA OR geneB by passing the argument
   \code{matches = "any"} through \code{...} to \code{\link{Contains}} (this
   is the default value). Find pathways that contain geneA AND geneB by
   changing this argument to \code{matches = "all"}. Find all genes in a 
   specified family by passing in one value to \code{short} and setting
   \code{partial = TRUE}.
}
\examples{
  data("colon_pathwayCollection")
  
  WhichPathways(colon_pathwayCollection, "MAP", partial = TRUE)
  
  WhichPathways(
    colon_pathwayCollection,
    c("MAP4K5", "RELA"),
    matches = "all"
  )

}
