% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_stdExpr_2_tidyAssay.R
\name{SE2Tidy}
\alias{SE2Tidy}
\title{Tidy a SummarizedExperiment Assay}
\usage{
SE2Tidy(summExperiment, whichAssay = 1)
}
\arguments{
\item{summExperiment}{A
\code{\link[SummarizedExperiment]{SummarizedExperiment-class}} object}

\item{whichAssay}{Because \code{SummarizedExperiment} objects can
store multiple related assays, which assay will be paired with a given
pathway collection to create an \code{Omics*}-class data container?
Defaults to 1, for the first assay in the object.}
}
\value{
The transposition of the assay in \code{summExperiment} to tidy form,
   with the column data (from the \code{colData} slot of the object) appended
   as the first columns of the data frame.
}
\description{
Extract the assay information from a
   \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}-object,
   transpose it, and and return it as a tidy data frame that contains assay
   measurements, feature names, and sample IDs
}
\details{
This function is designed to extract and transpose a "tall" assay
   data frames (where genes or proteins are the rows and patient or tumour
   samples are the columns) from a \code{SummarizedExperiment} object.
   This function also transposes the row (feature) names to column names and
   the column (sample) names to row names via the
   \code{\link{TransposeAssay}} function.
   
   NOTE: if this function stops working (again), please add a comment here:
   \url{https://github.com/gabrielodom/pathwayPCA/issues/83}
}
\examples{
   # THIS REQUIRES THE SummarizedExperiment PACKAGE.
   library(SummarizedExperiment)
   data(airway, package = "airway")
   
   airway_df <- SE2Tidy(airway)

}
