% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superPC_optimWeibull_pValues.R
\name{GumbelMixpValues}
\alias{GumbelMixpValues}
\title{Calculate the \eqn{p}-values from an optimal mixture of Weibull Extreme Value
   distributions for supervised PCA}
\usage{
GumbelMixpValues(tScore_vec, pathwaySize_vec, optimParams_vec)
}
\arguments{
\item{tScore_vec}{A vector of the maximum absolute \eqn{t}-scores for each
pathway (returned by the \code{\link{pathway_tScores}} function) when
under the alternative model.}

\item{pathwaySize_vec}{A vector of the number of genes in each pathway.}

\item{optimParams_vec}{The \emph{NAMED} vector of optimal Weibull Extreme
Value mixture distribution parameters returned by the
\code{\link{OptimGumbelMixParams}} function.}
}
\value{
A named vector of the estimated raw \eqn{p}-values for each gene
   pathway.
}
\description{
Calculate the \eqn{p}-values of test statistics from a mixture
   of two Weibull Extreme Value distributions.
}
\details{
The likelihood function is equation (4) in Chen et al (2008): a
   mixture of two Gumbel Extreme Value probability density functions, with
   mixing proportion \eqn{p}. Within the code of this function, the values
   \code{mu1}, \code{mu2} and \code{s1}, \code{s2} are placeholders for the
   mean and precision, respectively.

   See \url{https://doi.org/10.1093/bioinformatics/btn458} for more
   information.
}
\examples{
  # DO NOT CALL THIS FUNCTION DIRECTLY.
  # Use SuperPCA_pVals() instead.

\dontrun{
  ###  Load the Example Data  ###
  data("colon_pathwayCollection")
  n_int <- lengths(colon_pathwayCollection$pathways)


  ###  Simulate Maximum Absolute Control t-Values  ###
  # The SuperPCA algorithm defaults to 20 threshold values; the example
  #   pathway collection has 15 pathways.
  t_mat <- matrix(rt(15 * 20, df = 5), nrow = 15)

  absMax <- function(vec){
    vec[which.max(abs(vec))]
  }
  tAbsMax_num <- apply(t_mat, 1, absMax)


  ###  Calculate Optimal Parameters for the Gumbel Distribution  ###
  optParams_num <- OptimGumbelMixParams(
    max_tControl_vec = tAbsMax_num,
    pathwaySize_vec = n_int
  )


  ###  Simulate Maximum Absolute t-Values  ###
  tObs_mat <- matrix(rt(15 * 20, df = 3), nrow = 15)
  tObsAbsMax_num <- apply(tObs_mat, 1, absMax)


  ###  Calculate Observed-t-score p-Values  ###
  GumbelMixpValues(
    tScore_vec = tObsAbsMax_num,
    pathwaySize_vec = n_int,
    optimParams_vec = optParams_num
  )
}

}
\seealso{
\code{\link{OptimGumbelMixParams}}; \code{\link{pathway_tScores}};
   \code{\link{SuperPCA_pVals}}
}
\keyword{internal}
