% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathnetVisNetwork.R
\name{pathnetVisNetwork}
\alias{pathnetVisNetwork}
\title{Visualize enriched Reactome pathways as an interactive network}
\usage{
pathnetVisNetwork(
  network,
  networkLayout = "layout_nicely",
  nodeSizeRange = c(20, 50),
  nodeBorderWidth = 2.5,
  labelNodes = TRUE,
  nodeLabelSize = 60,
  nodeLabelColour = "black",
  nodeLabelLength = 40,
  edgeColour = "#848484",
  edgeWidthRange = c(5, 20),
  highlighting = TRUE
)
}
\arguments{
\item{network}{Tidygraph network object as output by \code{createPathnet}}

\item{networkLayout}{Desired layout for the network visualization. Defaults
to "layout_nicely", and should support most igraph layouts. See
\code{?visIgraphLayout} for more details.}

\item{nodeSizeRange}{Node size is mapped to the negative log of the
Bonferroni-adjusted p value, and this length-two numeric vector controls
the minimum and maximum. Defaults to \code{c(20, 50)}.}

\item{nodeBorderWidth}{Size of the node border, defaults to 2.5}

\item{labelNodes}{Boolean determining if nodes should be labeled. Note it
will only ever label enriched nodes/pathways.}

\item{nodeLabelSize}{Size of the node labels in pixels; defaults to 60.}

\item{nodeLabelColour}{Colour of the node labels; defaults to "black".}

\item{nodeLabelLength}{Length of the pathway name displayed before
truncation. Defaults to \code{40}.}

\item{edgeColour}{Colour of network edges; defaults to "#848484".}

\item{edgeWidthRange}{Edge width is mapped to the similarity measure (one
over distance). This length-two numeric vector controls the minimum and
maximum width of edges. Defaults to \code{c(5, 20)}.}

\item{highlighting}{When clicking on a node, should directly neighbouring
nodes be highlighted (other nodes are dimmed)? Defaults to TRUE.}
}
\value{
An interactive pathway, network or "pathnet"; object of class
"visNetwork"
}
\description{
Plots the network object generated from \code{createPathnet},
creating a visual and interactive representation of similarities/
interactions between pathways using their overlapping genes.
}
\details{
This function makes use of the visNetwork library, which allows for
various forms of interactivity, such as including text when hovering over
nodes, node selection and dragging (including multiple selections), and
highlighting nodes belonging to a larger group (e.g. top-level Reactome
category).
}
\examples{
data("sigoraDatabase", "sigoraExamples")

pathwayDistancesJaccard <- getPathwayDistances(
    pathwayData=dplyr::slice_head(
        dplyr::arrange(sigoraDatabase, pathwayId),
        prop=0.05
    ),
    distMethod="jaccard"
)

startingPathways <- pathnetFoundation(
    mat=pathwayDistancesJaccard,
    maxDistance=0.8
)

exPathnet <- pathnetCreate(
    pathwayEnrichmentResult=sigoraExamples[grepl(
        "Pos",
        sigoraExamples$comparison
    ), ],
    foundation=startingPathways,
    trim=TRUE,
    trimOrder=1
)

pathnetVisNetwork(exPathnet)

}
\references{
\url{https://datastorm-open.github.io/visNetwork/}
}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
}
