% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessibility_network.R
\name{accessibility_network}
\alias{accessibility_network}
\title{Build Network from Accessibility Peaks.}
\usage{
accessibility_network(table, promoter, pfm, genome, p.cutoff = 5e-05, w = 7)
}
\arguments{
\item{table}{(data.frame) Peaks, with "Chr", "Start" and "End" in column
name, and peak ID in row names.}

\item{promoter}{(GRanges) Promoter regions.}

\item{pfm}{(PFMatrixList) Positon Frequency Matrices (PFMs) of regulators.}

\item{genome}{(BSgenome or character) Genome build in which regulator motifs
will be searched.}

\item{p.cutoff}{(numeric) P-value cutoff for motifs searching within peaks
for TF identificaton.}

\item{w}{(numeric) Window size for motifs searching within peaks for TF
identificaton.}
}
\value{
(data.frame) Network, with "reg" and "target" in column name.
}
\description{
Build network from accessibility, e.g. ATAC-Seq peaks.
}
\examples{

table <- data.frame(Chr=c("chr1", "chr1"), Start=c(713689, 856337),
                    End=c(714685, 862152), row.names=c("A", "B"),
                    stringsAsFactors=FALSE)
regulators=c("FOXF2", "MZF1")
#peaks and regulators to be analyzed

library(GenomicRanges)
library(GenomicFeatures)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(org.Hs.eg.db)
library(annotate)
promoter <- promoters(genes(TxDb.Hsapiens.UCSC.hg19.knownGene))
names(promoter) <- getSYMBOL(names(promoter), data="org.Hs.eg")
promoter <- promoter[!is.na(names(promoter))]
#get promoter regions

library(JASPAR2018)
library(TFBSTools)
library(motifmatchr)
pfm <- getMatrixSet(JASPAR2018, list(species="Homo sapiens"))
pfm <- pfm[unlist(lapply(pfm, function(x) name(x))) \%in\% regulators]
#get regulator position frequency matrix (PFM) list

library(BSgenome.Hsapiens.UCSC.hg19)
accessibility_network(table, promoter, pfm, "BSgenome.Hsapiens.UCSC.hg19")
#generate network

}
\author{
DING, HONGXU (hd2326@columbia.edu)
}
