% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{filterZeroCols}
\alias{filterZeroCols}
\alias{filterZeroRows}
\title{Remove 0 columns/rows}
\usage{
filterZeroCols(object, verbose = TRUE)

filterZeroRows(object, verbose = TRUE)
}
\arguments{
\item{object}{A \code{MSnSet} object.}

\item{verbose}{Print a message with the number of filtered out
columns/row (if any).}
}
\value{
An \code{MSnSet}.
}
\description{
Removes all assay data columns/rows that are composed of only 0,
i.e. have a \code{colSum}/\code{rowSum} of 0.
}
\examples{
library("pRolocdata")
data(andy2011goCC)
any(colSums(exprs(andy2011goCC)) == 0)
exprs(andy2011goCC)[, 1:5] <- 0
ncol(andy2011goCC)
ncol(filterZeroCols(andy2011goCC))
}
\author{
Laurent Gatto
}
