% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRolocVis.R, R/pRolocVis_aggregation.R,
%   R/pRolocVis_compare.R, R/pRolocVis_explore.R
\name{pRolocVis}
\alias{pRolocVis}
\alias{pRolocVis_aggregate}
\alias{pRolocVis_compare}
\alias{pRolocVis_explore}
\title{Interactive visualisation of spatial proteomics data}
\usage{
pRolocVis(object, app = "explore", fcol = "markers", ...)

pRolocVis_aggregate(
  object,
  fcol = "markers",
  groupBy,
  fig.height = "700px",
  nchar = 25,
  ...
)

pRolocVis_compare(
  object,
  fcol = "markers",
  classProfiles = FALSE,
  fig.height = "400px",
  nchar = 25,
  ...
)

pRolocVis_explore(
  object,
  fcol = "markers",
  classProfiles = FALSE,
  fig.height = "700px",
  nchar = 25,
  ...
)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}, or an
\code{MSnSetList} of length 2 if using \code{"compare"}
application.}

\item{app}{The type of application requested: \code{"explore"}
(default), \code{"compare"} or
\code{"aggregate"}. See description below.}

\item{fcol}{The feature meta-data label (\code{fData} column name)
to be used for colouring. Default is \code{"markers"}. If set
to \code{NULL}, no annotation is expected. For the
\code{"compare"} app, a character vector of length 2 is
allowed to set different labels for each dataset. If
only one label is specified, then this single label 
will be used to identify the annotation column in both datasets. 
Please see example herein.}

\item{...}{Additional parameters passed to \code{plot2D} for the
\code{"explore"} (such as the dimensionality reduction
technique, and methods), \code{"compare"} apps. For 
the \code{"aggregate"} app this is for additional parameters 
to be passed to \code{combineFeatures}.}

\item{groupBy}{The feature meta-data label (\code{fData} column name)
to be used for summarising the features to be combined.}

\item{fig.height}{Height of the figure.}

\item{nchar}{Maximum number of characters of the subcellular class
names, before their names are truncated. Default is 25.}

\item{classProfiles}{A \code{logical} indicating if a tab displaying
individual class profile plots should be displayed. Default is \code{FALSE}.}
}
\description{
These functions allow one to explore spatial proteomics data
interactively.
}
\details{
The function \code{pRolocVis} is a wrapper for
\code{pRolocVis_pca}, \code{pRolocVis_compare}.
and \code{pRolocVis_aggregate}. These Shiny apps allow to explore and
analyse interactively spatial proteomics data.

The \code{explore} Shiny app allows exploration of quantitative data
(1) visually through a projection of the dataset, (2)
protein profiles, and (3) a searchable feature data table,
allowing visualisation of sets of proteins of interest. 

The \code{compare} Shiny app is meant for comparing protein
localisation between two conditions, or two different experiments,
replicates etc.

The \code{aggregation} Shiny app displays a scatter plot of the
maximum or mean distances within each feature (e.g. protein group)
according to its components (e.g. peptides) defined by the
\code{groupBy} argument. A PCA plot of the components is also
displayed. It can be used for visualising peptides, PSMs or any
other features defined in the feature data of the \code{MSnSet}
and their distributions.
}
\examples{
library("pRoloc")
library("pRolocdata")

## Load the Explore app
data(hyperLOPIT2015)
if (interactive()) {
  pRolocVis(hyperLOPIT2015)
  pRolocVis(hyperLOPIT2015, method = "t-SNE")
  ## store the t-SNE coords and pass a matrix to pRolocVis
  xx <- plot2D(hyperLOPIT2015, method = "t-SNE")
  pRolocVis(xx, method = "none", methargs = list(hyperLOPIT2015))
}

## Load the Compare app
data("hyperLOPITU2OS2018")
data("lopitdcU2OS2018")
xx <- MSnSetList(list(hyperLOPITU2OS2018, lopitdcU2OS2018))
if (interactive()) {
  pRolocVis(xx, app = "compare", fcol = c("markers", "final.assignment"))
}

## Visualise the location and distribution of peptides per protein group
data("hyperLOPIT2015ms2psm")
if (interactive()) {
  ## Combine PSM data to peptides
  hl <- combineFeatures(hyperLOPIT2015ms2psm,
                        groupBy = fData(hyperLOPIT2015ms2psm)$Sequence,
                        method = median)
  ## Visualise peptides according to protein group
  pRolocVis(hl, app = "aggregate", fcol = "markers",
            groupBy = "Protein.Group.Accessions")
}
}
\seealso{
The package vignette: \code{vignette("pRolocGUI")}.
}
\author{
Lisa Breckels, Thomas Naake and Laurent Gatto
}
