% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryWithContrasts.R
\name{queryWithContrasts}
\alias{queryWithContrasts}
\title{Query the contrast database with a set of contrasts}
\usage{
queryWithContrasts(
  contrasts,
  use = c("expressed.in.both", "all.genes"),
  exprThr = 0.25,
  organism = c("Human", "Mouse"),
  plotType = c("violin", "manh", "none"),
  detailTopn = 10,
  verbose = TRUE,
  BPPARAM = BiocParallel::bpparam(),
  chunk_size = 500,
  mode = c("ANALYSIS", "DEMO")
)
}
\arguments{
\item{contrasts}{A \code{SummarizedExperiment} object with assays containing
contrasts named INPUT_CONTRASTS, DECODED_CONTRASTS and RESIDUAL_CONTRASTS
(at least one should be present) and context information in an assay
named CONTEXT. The latter is only required when use="expressed.in.both".
This is typically generated using \code{decomposeVar}.}

\item{use}{Determines if all.genes or genes expressed in both query and
target context will be used. Note that "expressed.in.both", though more
accurate, is slower.}

\item{exprThr}{is the quantile in the provided context that determines the
expression value above which a gene is considered to be expressed. This
same value is then used for thresholding the contrast database. Only
applies when use="expressed.in.both".}

\item{organism}{Uses the `orthosData` contrast database from this
species. One of \code{"Human"} or \code{"Mouse"}.}

\item{plotType}{Select the type of visualization for the query results
\code{"violin", "manh"} or \code{"none"} to suppress the plotting.}

\item{detailTopn}{specifies the number of top hits for which metadata will
be returned in the TopHits slot of the results.}

\item{verbose}{Logical scalar indicating whether to print messages along
the way.}

\item{BPPARAM}{BiocParallelParam object specifying how parallelization is to
be performed using e.g. \code{\link[BiocParallel]{MulticoreParam}})
or \code{\link[BiocParallel]{SnowParam}}).}

\item{chunk_size}{Column dimension for the grid used to read blocks from the
HDF5 Matrix. Sizes between 250 and 1000 are recommended. Smaller sizes
reduce memory usage.}

\item{mode}{When in "ANALYSIS" mode (default) the complete contrast DB is
queried. "DEMO" mode employs a small "toy" database for the queries.
"DEMO" should only be used for testing/demonstration purposes
and never for actual analysis purposes.}
}
\value{
A list with three elements called "pearson.rhos", "zscores" and
    "TopHits", containing raw and z-scored Pearson's rho correlation
    coefficients between the query contrast(s) and the contrasts in the
    database, as well as detailed metadata for the \code{detailTopn} best
    hits.
}
\description{
Query the contrast database with a set of contrasts
}
\examples{
MKL1_human <- readRDS(system.file("extdata", "GSE215150_MKL1_Human.rds",
package = "orthos"))

# Decompose contrasts:
dec_MKL1_human <- decomposeVar(M = MKL1_human, treatm = c(2, 3), cntr = c(1, 1), 
                               organism = "Human", verbose = FALSE)

# Perform query against contrast DB with the decomposed fractions.
# !!!Note!!! mode="DEMO" for demonstration purposes only.                             
params <- BiocParallel::MulticoreParam(workers = 2)                              
query.res.human <- queryWithContrasts(dec_MKL1_human, organism = "Human", 
                                      BPPARAM = params, verbose = FALSE, 
                                      mode = "DEMO")

}
\author{
Panagiotis Papasaikas
}
