% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotQueryResults.R
\name{plotQueryResultsManh}
\alias{plotQueryResultsManh}
\title{Visualize query results as a composite manhattan/density plot.}
\usage{
plotQueryResultsManh(queryResults, doPlot = TRUE)
}
\arguments{
\item{queryResults}{A list containing the results of a query performed with
\code{queryWithContrasts}}

\item{doPlot}{Logical scalar specifying if a plot should be generated.}
}
\value{
A composite manhattan/density plot for the scores of queries using
different contrast components against the respective contrast DBs.
}
\description{
Visualize query results as a composite manhattan/density plot.
}
\examples{
MKL1_human <- readRDS(system.file("extdata", "GSE215150_MKL1_Human.rds",
package = "orthos"))

# Decompose contrasts:
dec_MKL1_human <- decomposeVar(M = MKL1_human, treatm = c(2, 3), cntr = c(1, 1), 
                              organism = "Human", verbose = FALSE)

# Perform query against contrast DB with the decomposed fractions.
# !!!Note!!! mode="DEMO" for demonstration purposes only.                             
params <- BiocParallel::MulticoreParam(workers = 2)                              
query.res.human <- queryWithContrasts(dec_MKL1_human, organism = "Human", 
                                     BPPARAM = params, verbose = FALSE, 
                                     mode = "DEMO")
                                     
# plot results for individual contrasts using composite Manhattan/Density plots:
ManhDensPlots <- plotQueryResultsManh(query.res.human, doPlot = FALSE)
ManhDensPlots[["caMKL1"]]


}
\author{
Panagiotis Papasaikas, Michael Stadler
}
