% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_primers_tree.R
\name{get.tree.seqs}
\alias{get.tree.seqs}
\title{Determine Tree Consensus Sequences}
\usage{
get.tree.seqs(tree, max.degen, primer.candidates)
}
\arguments{
\item{tree}{The phylogenetic tree.}

\item{max.degen}{The maximal degeneration of consensus primers.}

\item{primer.candidates}{Alignment of primers.}
}
\value{
Data frame with consensus primers extracted from the tree.
}
\description{
Creates all possible consensus sequences from a phylogenetic tree.
}
\details{
Ambiguous sequences are only generated with a degeneracy of at most \code{max.degen}. 
The tree is iterated from leaves to the top, i.e., starting from least degeneracy to most degeneracy. 
Merges only take place when the degeneracy of the resulting sequence would
be at most \code{max.degen}. Gaps are removed from the alignments.
}
\keyword{internal}
