% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{get.cvg.constraint.settings}
\alias{get.cvg.constraint.settings}
\title{Gather all Coverage Constraints.}
\usage{
get.cvg.constraint.settings(
  allowed.stop.codons,
  allowed.efficiency,
  disallowed.mismatch.pos,
  allowed.anneal.deltaG,
  allowed.substitutions,
  allowed.coverage.model
)
}
\arguments{
\item{allowed.stop.codons}{Whether mismatch binding events inducing
stop codons in the amino acid sequence are allowed.}

\item{allowed.efficiency}{Min/max for primer efficiency.}

\item{disallowed.mismatch.pos}{The positions from the 3' terminal
end of primers where mismatches shall be prevented.}

\item{allowed.anneal.deltaG}{Maximal allowed free energy of template-primer annealing.}

\item{allowed.substitutions}{Whether mismatch binding events inducing substitutions
in the amino acid sequence are allowed.}
}
\value{
List with all coverage constraint settings.
}
\description{
Constructor for coverage constraint settings.
}
\keyword{internal}
