% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_algo.R
\name{compute.Tm.sets}
\alias{compute.Tm.sets}
\title{Cross-Dimerization Filtering}
\usage{
compute.Tm.sets(
  primer.df,
  template.df,
  Tm.brackets,
  settings,
  mode.directionality = c("fw", "rev"),
  primer_conc,
  template_conc,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  allowed.mismatches,
  allowed.other.binding.ratio,
  allowed.stop.codons,
  allowed.region.definition,
  disallowed.mismatch.pos,
  opti.mode = FALSE,
  required.cvg = NULL,
  primers.fw = NULL,
  diagnostic.location = NULL,
  updateProgress = NULL
)
}
\arguments{
\item{primer.df}{Primer data frame.}

\item{template.df}{Template data frame.}

\item{Tm.brackets}{Data frame with target primer melting temperatures.}

\item{settings}{A \code{DesignSettings} object.}

\item{mode.directionality}{Identifier of strand for which primers shall be designed.}

\item{primer_conc}{Primer concentration.}

\item{template_conc}{Template concentration.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris ion concentration.}

\item{allowed.mismatches}{The number of mismatches primers are allowed to have with the templates.}

\item{allowed.other.binding.ratio}{Ratio of primers allowed to bind to non-target regions.}

\item{allowed.stop.codons}{Consider mismatch binding events that induce stop codons.}

\item{allowed.region.definition}{Definition of the allowed region.}

\item{disallowed.mismatch.pos}{The number of positions from the primer 3' end where mismatches should not be allowed.
All primers binding templates with mismatches within \code{disallowed.mismatch.pos} from the 3' end are disregarded.}

\item{opti.mode}{Compute optimization constraints and relax delta Tm if necessary.}

\item{required.cvg}{Target coverage ratio.}

\item{primers.fw}{Already designed primer sets for the target temperatures given in \code{Tm.brackets}.
Used to determine cross-dimerization.}

\item{diagnostic.location}{Directory for storing results.}

\item{updateProgress}{Shiny progress callback function.}

\item{primers.rev}{The primer data set to be filtered for cross-dimers.}

\item{opti.constraints}{List with optimization constraint settings.}

\item{annealing.temp}{The PCR annealing temperature.}
}
\value{
\code{primers.rev} with removed cross-dimerizing primers.

Primer data frames for every target temperature.
}
\description{
Removes cross-dimerizing primers from the input data.
}
\keyword{Creation}
\keyword{Cross-dimerization}
\keyword{Melting}
\keyword{Sets.}
\keyword{Stratifies}
\keyword{Temperature}
\keyword{\code{primers.fw}}
\keyword{a}
\keyword{according}
\keyword{and}
\keyword{between}
\keyword{case}
\keyword{checked}
\keyword{checks}
\keyword{constraints.}
\keyword{data}
\keyword{forward}
\keyword{frames}
\keyword{here,}
\keyword{in}
\keyword{internal}
\keyword{is}
\keyword{list}
\keyword{melting}
\keyword{of}
\keyword{optimization}
\keyword{primer}
\keyword{primers}
\keyword{provided.}
\keyword{reverse}
\keyword{run}
\keyword{second}
\keyword{temperature-dependent}
\keyword{temperatures}
\keyword{their}
\keyword{this}
\keyword{to}
\keyword{with}
