% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toggle.helperGates.R
\name{gt_toggle_helpergates}
\alias{gt_toggle_helpergates}
\alias{toggle.helperGates}
\alias{gt_get_helpergates}
\alias{get.helperGates}
\alias{gt_delete_helpergates}
\alias{delete.helperGates}
\title{toggle/delete the hidden flag of the helper gates}
\usage{
gt_toggle_helpergates(gt, gs)

gt_get_helpergates(gt, gs)

gt_delete_helpergates(gt, gs)
}
\arguments{
\item{gt}{gatingTemplate object}

\item{gs}{GatingSet}
}
\description{
The helper gates are defined as the referred gates in csv template. And all the chidlren of referred gates are also 
referred gates thus they are considered the helper gates and can usually be hidden to simply the final gating tree.
}
\details{
Note that delete action is NOT reversible.
}
\examples{
\dontrun{
gt <- gatingTemplate(gtFile)
#run the gating
gt_gating(gt, gs)
#hide the gates that are not of interest
gt_toggle_helpergates(gt, gs) 
#or simply remove them if you are sure they will not be useful in future
gt_delete_helpergates(gt, gs) 
}
}
