% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gating-functions.R
\name{gate_mindensity}
\alias{gate_mindensity}
\alias{mindensity}
\title{Determines a cutpoint as the minimum point of a kernel density estimate
between two peaks}
\usage{
gate_mindensity(
  fr,
  channel,
  filterId = "",
  positive = TRUE,
  gate_range = NULL,
  min = NULL,
  max = NULL,
  peaks = NULL,
  ...
)
}
\arguments{
\item{fr}{a \code{flowFrame} object}

\item{channel}{TODO}

\item{filterId}{TODO}

\item{positive}{If \code{TRUE}, then the gate consists of the entire real
line to the right of the cutpoint. Otherwise, the gate is the entire real
line to the left of the cutpoint. (Default: \code{TRUE})}

\item{gate_range}{numeric vector of length 2. If given, this sets the bounds
on the gate applied. If no gate is found within this range, we set the gate to
the minimum value within this range if \code{positive} is \code{TRUE} and the
maximum value of the range otherwise.}

\item{min}{a numeric value that sets the lower boundary for data filtering}

\item{max}{a numeric value that sets the upper boundary for data filtering}

\item{peaks}{\code{numeric} vector. If not given , then perform peak detection first by .find_peaks}

\item{...}{Additional arguments for peak detection.}
}
\value{
a \code{rectangleGate} object based on the minimum density cutpoint
}
\description{
We fit a kernel density estimator to the cells in the \code{flowFrame} and
identify the two largest peaks. We then
select as the cutpoint the value at which the minimum density is attained
between the two peaks of interest.
}
\details{
In the default case, the two peaks of interest are the two largest peaks
obtained from the \code{link{density}} function. 

In the special case that there is only one peak, we are conservative and set
the cutpoint as the \code{min(x)} if \code{positive} is \code{TRUE}, and the
\code{max(x)} otherwise.
}
\examples{
\dontrun{
 gate <- gate_mindensity(fr, channel = "APC-A") # fr is a flowFrame
}
}
