% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_entities2.R
\name{setup_entities2}
\alias{setup_entities2}
\title{preparing for a small number of entry points to owlready2 mediated by
basilisk, this setup function will ingest OWL, enumerate classes and their
names, and produce the 'parents' list, which can then be used with ontology_index
to produce a functional ontology representation}
\usage{
setup_entities2(owlfn, cache_object = TRUE)
}
\arguments{
\item{owlfn}{character(1) path to OWL file}

\item{cache_object}{logical(1) if TRUE, cache the `ontology_index` instance in BiocFileCache::BiocFileCache()}
}
\description{
preparing for a small number of entry points to owlready2 mediated by
basilisk, this setup function will ingest OWL, enumerate classes and their
names, and produce the 'parents' list, which can then be used with ontology_index
to produce a functional ontology representation
}
\note{
Production of an `ontology_index` instance will often throw a warning when "Thing" is
part of the ontology.  suppressWarnings has been used in the code to suppress this.  This
may be too aggressive an approach.
}
\examples{
pa = get_ordo_owl_path()
orde = setup_entities2(pa)
orde
}
