% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxi_stats.R
\name{multi.t.test}
\alias{multi.t.test}
\title{Function to perform multiple t-tests on an expression matrix}
\usage{
multi.t.test(x, pheno, compare = NULL, fillNA = FALSE, ...)
}
\arguments{
\item{x}{an expression matrix, usually log10 transformed.}

\item{pheno}{phenotype data of x, the number of rows in \code{pheno} must equal
the number of columns of \code{x}. Please refer to examples for more details.}

\item{compare}{NULL or a matrix with three columns to define the comparisons to do. 
When a matrix is given, the first column should be one of the column headers 
in \code{pheno}; then the second and third columns should be two values 
presented (more than once) in the columns of \code{pheno} selected by the
values in the first column. The samples mapped to the two values are compared. 
If paired comparisons to be done, the orders of samples should be mapped}

\item{fillNA}{logical; whether NA should be filled? If FALSE (default), t test 
will be performed whenever possible. If not possible, then NA will be returned. 
If TRUE, the missing value will be replaced using \code{\link{fillNA}}.}

\item{...}{other parameters passed to \code{\link{t.test}}}
}
\value{
a \code{data.frame} stores the t-test results with the follow columns:
\code{mean|[selected header in pheno]|[group 1 in test]} - The mean value of group 1
\code{n value|[selected header in pheno]|[group 1 in test]} - The number of value used in the test for group 1
\code{quantile|[selected header in pheno]|[group 1 in test]} - The quantile of means values in group 1
\code{mean|[selected header in pheno]|[group 2 in test]} - The mean value of group 2
\code{n value|[selected header in pheno]|[group 2 in test]} - The number of value used in the test for group 2
\code{quantile|[selected header in pheno]|[group 2 in test]} - The quantile of means values in group 2
\code{ttest|[group 1 in test]_vs_[group 2 in test]|pvalue} - The p-value return by \code{\link{t.test}}
\code{ttest|[group 1 in test]_vs_[group 2 in test]|log.pvalue} - The -log10 transformed p-value
\code{ttest|[group 1 in test]_vs_[group 2 in test]|fdr} - The BH method corrected p-values, e.g. FDR
\code{ttest|[group 1 in test]_vs_[group 2 in test]|log.fdr} - The -log10 transformed FDR
\code{ttest|[group 1 in test]_vs_[group 2 in test]|mean.diff} - The difference between the means of the two groups, e.g. fold change
}
\description{
This is a convenience function to perform multiple student's t-test. 
  The output is in a format ready to be incorporated into object to be visualized by 
  \code{omicsViewer}. This function use \code{\link{t.test}}.
}
\examples{
# reading expression
packdir <- system.file("extdata", package = "omicsViewer")
expr <- read.delim(file.path(packdir, "expressionMatrix.tsv"), stringsAsFactors = FALSE)
# reading phenotype data
pd <- read.delim(file.path(packdir, "sampleGeneral.tsv"), stringsAsFactors = FALSE)

## Single t-test
head(pd)
# define comparisons
tests <- c("Origin", "RE", "ME")
tres <- multi.t.test(x = expr, pheno = pd, compare = tests)

## multiple t-test
head(pd)
# define comparisons
tests <- rbind(
c("Origin", "RE", "ME"),
c("Origin", "RE", "LE"),
c('TP53.Status', "MT", "WT")
)
tres <- multi.t.test(x = expr, pheno = pd, compare = tests)
}
