% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotyping.R
\name{inferRelations}
\alias{inferRelations}
\title{predict mismatches}
\usage{
inferRelations(data, n = 100, plot.it = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{data}{output from allelesharing}

\item{n}{= 100 default interpolation for showing the
classification boundaries}

\item{plot.it}{= TRUE default plot classification graph and
returing mismatches otherwise return all}

\item{verbose}{default FALSE, if TRUE show confusion matrix}

\item{...}{optional plotting argument passed to plot}
}
\value{
predicted mismatches
}
\description{
predict mismatches
}
\details{
based on all data a classifier is build using Linear Discriminant
Analysis and on the same data a prediction is performed in order
to detect wrong sample relationships. The assumption is that the
majority of sample relations is correct otherwise we could not do
this!
}
\examples{
set.seed(12345)
beta <- matrix(runif(100*10, 0,1), nrow=100)
beta[1:5, 1:5]
colnames(beta) <- paste0("sample", 1:10)
genotype <- beta2genotype(beta)
genotype[1:5, 1:5]
data <- alleleSharing(genotype)
head(data)
inferRelations(data)
}
\author{
mvaniterson
}
