% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/runRankGMF.R
\name{calculateRankGMF}
\alias{calculateRankGMF}
\alias{runRankGMF}
\alias{calculateRankGMF,ANY-method}
\alias{calculateRankGMF,SummarizedExperiment-method}
\alias{calculateRankGMF,SingleCellExperiment-method}
\alias{calculateRankGMF,QFeatures-method}
\alias{runRankGMF,SummarizedExperiment-method}
\alias{runRankGMF,SingleCellExperiment-method}
\alias{runRankGMF,QFeatures-method}
\title{Perform an eigendecomposition for model selection based on a screeplot.}
\usage{
calculateRankGMF(x, ...)

runRankGMF(x, ...)

\S4method{calculateRankGMF}{ANY}(
  x,
  family = gaussian(),
  maxcomp = 100,
  ntop = NULL,
  X = NULL,
  Z = NULL,
  offset = NULL,
  weights = NULL,
  subset_row = NULL,
  scale = FALSE,
  transposed = FALSE,
  BSPARAM = bsparam(),
  BPPARAM = SerialParam(),
  method = "oht",
  normalize = FALSE,
  ...
)

\S4method{calculateRankGMF}{SummarizedExperiment}(
  x,
  ...,
  exprs_values = 1,
  assay.type = exprs_values,
  family = gaussian()
)

\S4method{calculateRankGMF}{SingleCellExperiment}(
  x,
  ...,
  exprs_values = 1,
  dimred = NULL,
  n_dimred = NULL,
  assay.type = exprs_values,
  family = gaussian()
)

\S4method{calculateRankGMF}{QFeatures}(
  x,
  ...,
  exprs_values = NULL,
  dimred = NULL,
  n_dimred = NULL,
  assay.type = NULL,
  family = gaussian()
)

\S4method{runRankGMF}{SummarizedExperiment}(x, ...)

\S4method{runRankGMF}{SingleCellExperiment}(x, ..., altexp = NULL, name = "rank_GMF")

\S4method{runRankGMF}{QFeatures}(x, ..., exprs_values = NULL, assay.type = NULL)
}
\arguments{
\item{x}{For \code{calculateRankGMF}, a numeric matrix of expression counts or
mass spectrometry intensities where rows are features and columns are cells.
Alternatively, a \link[SummarizedExperiment]{SummarizedExperiment-class} or
\link[SingleCellExperiment]{SingleCellExperiment-class} containing such a
matrix.

For \code{runRankGMF}, a
\link[SummarizedExperiment]{SummarizedExperiment-class},
\link[SingleCellExperiment]{SingleCellExperiment-class} or
\link[QFeatures]{QFeatures} object
containing such a matrix.}

\item{...}{For the \code{calculateRankGMF} generic, additional arguments to
pass to specific methods such as \code{\link[sgdGMF]{sgdgmf.rank}}.
For the SummarizedExperiment and SingleCellExperiment methods, additional
arguments to pass to the ANY method.

For \code{runRankGMF}, additional arguments to pass to
\code{calculateRankGMF}.}

\item{family}{The distribution family that is used for the estimation of
the parameters.}

\item{maxcomp}{Scalar indicating the maximal number of eigenvalues to
compute.}

\item{ntop}{Numeric scalar specifying the number of features with the
highest variances to use for dimensionality reduction.
Default uses all features.}

\item{X}{Sample-level covariate matrix. Defaults to column of ones.}

\item{Z}{Feature-level covariate matrix. Defaults to column of ones.}

\item{offset}{offset matrix with same dimensions as x that is added to the
linear predictor. Note that if family = poisson(),
this should therefore be on the log-scale}

\item{weights}{weight matrix with same dimensions as x that determines the
weight of each observation.}

\item{subset_row}{Vector specifying the subset of features to use for
dimensionality reduction.
This can be a character vector of row names, an integer vector of row
indices or a logical vector.}

\item{scale}{Logical scalar, should the expression values be standardized?
Not recommended for non-Gaussian data.}

\item{transposed}{Logical scalar, is \code{x} transposed with cells in rows?}

\item{BSPARAM}{A \link[BiocSingular]{BiocSingularParam-class} object
specifying which algorithm should be used to perform the PCA.
This is used in \code{\link[scater]{runPCA}} to put all information in the
sample latent factors.}

\item{BPPARAM}{A \link[BiocParallel]{BiocParallelParam-class} object
specifying whether the cross-validation
should be parallelized. If BPPARAM$workers > 1 and control.cv$parallel and
control.cv$nthreads are
not specified, parallelization is enabled with nthreads = BPPARAM$workers.}

\item{method}{rank selection method, see \code{\link[sgdGMF]{sgdgmf.rank}}.}

\item{normalize}{if TRUE, standardize the residual matrix for each feature.}

\item{exprs_values}{Alias to \code{assay.type}.}

\item{assay.type}{Integer scalar or string indicating which assay of
\code{x} contains the values of interest.}

\item{dimred}{String or integer scalar specifying the existing
dimensionality reduction results to use.}

\item{n_dimred}{Integer scalar or vector specifying the dimensions to use
if \code{dimred} is specified.}

\item{altexp}{String or integer scalar specifying an alternative experiment
containing the input data.}

\item{name}{String specifying the name to be used to store the result in
the metadata of the output.}
}
\value{
A list containing the eigenvalues. If a
\link[SummarizedExperiment]{SummarizedExperiment-class} or
\link[SingleCellExperiment]{SingleCellExperiment-class} was
given as input, this is stored in the metadata of this object.
}
\description{
Perform an eigendecomposition for model selection based on a screeplot.
}
\details{
sgdGMF uses sampling of the data to estimate the parameters, which can
alter with different seeds. Also, cross-validation
puts a random selection of values to missing. This means that the result
will change slightly across different runs.
For full reproducibility, users should call \code{\link{set.seed}} prior to
running \code{runRankGMF} with such algorithms.
(Note that this includes \code{BSPARAM=\link[BiocSingular]{bsparam}()},
which uses approximate algorithms by default.)

For feature selection and using alternative Experiments, see
\code{\link{runGMF}}.
}
\examples{
example_sce <- mockSCE(ncells = 200, ngenes = 100)
example_sce <- runRankGMF(example_sce,
                         exprs_values="counts",
                         family = poisson(),
                         maxcomp = 10)
head(metadata(example_sce)[["rank_GMF"]])
plotRank(example_sce)
}
\seealso{
\code{\link[sgdGMF]{sgdgmf.rank}}, for the underlying calculations.
}
\author{
Alexandre Segers
}
