% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R, R/ResultSet-plotLambda.R
\docType{methods}
\name{plotLambda}
\alias{plotLambda}
\alias{plotLambda,ResultSet-method}
\alias{plotLambda}
\title{Plot lambda score for all results in a ResultSet}
\usage{
plotLambda(object, width = 0.75)

\S4method{plotLambda}{ResultSet}(object, width = 0.75)
}
\arguments{
\item{object}{An object of class \link{ResultSet}}

\item{width}{(default \code{0.70}) width of the bar}
}
\value{
A ggplot2 object
}
\description{
This method draws a baplor with the lambda score of each result in the
given \link{ResultSet}.
}
\examples{
data("asr", package = "omicRexposome")
plotLambda(asr)
}
\seealso{
\code{\link{plotHits}} for a graphical representation of
the hits per analysys, \code{\link{tableLambda}} for the lambda
score per analysys, \code{\link{tableHits}} for the hists per analysys
}
