% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-Matched.R
\name{plotPropensity}
\alias{plotPropensity}
\alias{plotPropensity,Matched,character_OR_missing,character_OR_missing,character_OR_missing-method}
\title{Propensity score plotting for Matched objects}
\usage{
plotPropensity(
  x,
  sets = c("focal", "matched", "pool", "unmatched"),
  type = NULL,
  log = NULL,
  ...
)

\S4method{plotPropensity}{Matched,character_OR_missing,character_OR_missing,character_OR_missing}(x, sets, type, log, thresh = 12)
}
\arguments{
\item{x}{Matched object}

\item{sets}{Character vector describing which matched set(s)
to include in the plot. Options are 'focal', 'matched',
'pool', or 'unmatched'. Multiple options are accepted.}

\item{type}{Character naming the plot type. Available
options are one of either 'ridges', 'jitter', 'lines',
or 'bars'. Note that for large datasets, use of 'jitter'
is discouraged because the large density of points can
stall the R-graphics device.}

\item{log}{Character vector describing which axis or
axes to apply log-transformation. Available options are
'x' and/or 'y'.}

\item{...}{Additional arguments.}

\item{thresh}{Integer describing the number of
unique values required to classify a numeric
variable as discrete (and convert it to a factor).
If the number of unique values exceeds \code{thresh}
then the variable is considered continuous.}
}
\value{
Returns a plot of propensity score distributions
among matched sets.
}
\description{
This function plots the distribution of propensity scores
from each matched set of a Matched object.
}
\details{
\code{plotPropensity} uses the \code{thresh} argument
to determine whether to plot propensity scores as
continuous (line plot) or catetgorical (bar plot).
These settings can also be overwritten manually.
}
\examples{
## Matched example dataset
set.seed(123)
mdf <- makeExampleMatchedDataSet(matched = TRUE)

## Visualize propensity scores
plotPropensity(mdf)
plotPropensity(mdf,
              sets = c('focal', 'matched', 'pool'))
plotPropensity(mdf,
              sets = c('focal', 'matched', 'pool'),
              type = 'ridges')
plotPropensity(mdf,
              sets = c('focal', 'matched', 'pool'),
              type = 'jitter')

}
\seealso{
\code{\link[=plotCovariate]{plotCovariate()}} to plot covariate distributions.
}
