% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_from_mae.R
\name{extract_from_mae}
\alias{extract_from_mae}
\title{Extract a list of harmonized data matrices from an MAE object}
\usage{
extract_from_mae(MAE_object, subset_data = "all", harmonize = TRUE)
}
\arguments{
\item{MAE_object}{an MAE object containing experiment data for extraction
colData field optional
experiments should either be SummarizedExperiment, SingleCellExperiment, or
RangedSummarizedExperiment classes}

\item{subset_data}{\itemize{
\item `all` use all experiments in MAE object
\item `c(omic1,omic2,...)` list of omics from names(MAE_object)
}}

\item{harmonize}{A boolean whether samples should be checked for duplicates \itemize{
\item `TRUE` (default) merges duplicate samples via the `MultiAssayExperiment::mergeReplicates` function
\item `FALSE` skips sample duplicate check - USE THIS FOR LARGE-SAMPLE DATASETS.
}}
}
\value{
List of harmonized data matrices for input into `nipals_multiblock()`
}
\description{
Extract a list of harmonized data matrices for
input into nipals_multiblock() from an MAE object
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                              colData=metadata_NCI60)
NCI60_input = extract_from_mae(data_blocks_mae,subset='all')
}
