% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.makeDendro}
\alias{.makeDendro}
\title{Make the dendrogram for heatmap-style plots}
\usage{
.makeDendro(df, rowVal, colVal, value)
}
\arguments{
\item{df}{The data frame to be clustered}

\item{rowVal}{The rows to be clustered}

\item{colVal}{The value which will become column names}

\item{value}{The value to use for the clustering}
}
\value{
A dendrogram
}
\description{
Set the clusters for heatmap-style interactive plots
}
\examples{
# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fileList <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)
cols <- c("Filename", "Position", "Illumina_Universal_Adapter")
ac <- getModule(fileList, "Adapter_Content")[cols]
ngsReports:::.makeDendro(df = ac,
                            rowVal = "Filename",
                            colVal = "Position",
                            value = "Illumina_Universal_Adapter")

}
\keyword{internal}
