% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netboost.R
\name{nb_plot_dendro}
\alias{nb_plot_dendro}
\title{Plot dendrogram from Netboost output.}
\usage{
nb_plot_dendro(
  nb_summary = NULL,
  labels = FALSE,
  main = "",
  colorsrandom = FALSE
)
}
\arguments{
\item{nb_summary}{Netboost results as generated by the nb_summary function.}

\item{labels}{Boolean flag whether labels should be attached to
the leafs.}

\item{main}{Plot title.}

\item{colorsrandom}{Boolean flag whether module colors should be
shuffeled.}
}
\value{
invisible null
}
\description{
Plot dendrogram from Netboost output.
}
\examples{
data('tcga_aml_meth_rna_chr18',  package='netboost')
results <- netboost(datan = tcga_aml_meth_rna_chr18, stepno = 20L,
soft_power = 3L, min_cluster_size = 10L, n_pc = 2, scale=TRUE,
ME_diss_thres = 0.25, qc_plot = FALSE)
set.seed(1234) # reproducible but shuffled color-module matching
nb_plot_dendro(nb_summary = results, labels = FALSE, main = 'Test',
colorsrandom = TRUE)

}
