% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netboost.R
\name{netboost}
\alias{netboost}
\title{Netboost clustering.}
\usage{
netboost(
  datan = NULL,
  stepno = 20L,
  filter_method = c("boosting", "skip", "kendall", "spearman", "pearson"),
  until = 0L,
  progress = 1000L,
  mode = 2L,
  soft_power = NULL,
  max_singleton = ncol(datan),
  qc_plot = TRUE,
  min_cluster_size = 2L,
  ME_diss_thres = 0.25,
  n_pc = 1,
  robust_PCs = FALSE,
  nb_min_varExpl = 0.5,
  cores = as.integer(getOption("mc.cores", 2)),
  scale = TRUE,
  method = c("pearson", "kendall", "spearman"),
  verbose = getOption("verbose")
)
}
\arguments{
\item{datan}{Data frame were rows correspond to samples and columns to
features.}

\item{stepno}{Integer amount of boosting steps applied in the filtering
step}

\item{filter_method}{The following filtering methods are supported:
"boosting" (non-zero coefficients in likelihood based boosting),
"skip" (no filter), "kendall" (stats::cor.test),
"spearman" (stats::cor.test), "pearson" (stats::cor.test)}

\item{until}{Stop at index/column (if 0: iterate through all columns).
For testing purposes in large datasets.}

\item{progress}{Integer. If > 0, print progress after every X steps (
Progress might not be reported completely accurate due to parallel execution)}

\item{mode}{Integer. Mode (0: x86, 1: FMA, 2: AVX). Features are only
available if compiled accordingly and available on the hardware.}

\item{soft_power}{Integer. Exponent of the transformation. Set
automatically based on the scale free topology criterion if unspecified.}

\item{max_singleton}{Integer. The maximal singleton in the clustering.
Usually equals the number of features.}

\item{qc_plot}{Logical. Should plots be created?}

\item{min_cluster_size}{Integer. The minimum number of features in one
module.}

\item{ME_diss_thres}{Numeric. Module Eigengene Dissimilarity Threshold for
merging close modules.}

\item{n_pc}{Number of principal components and variance explained
entries to be calculated. The number of returned variance explained
entries is currently ‘min(n_pc,10)’. If given ‘n_pc’ is 
greater than 10, a warning is issued.}

\item{robust_PCs}{Should PCA be calculated on ranked data (Spearman PCA)?
Rotations will not correspond to original data if this is applied.}

\item{nb_min_varExpl}{Minimum proportion of variance explained for
returned module eigengenes. The number of PCs is capped at n_pc.}

\item{cores}{Integer. Amount of CPU cores used (<=1 : sequential)}

\item{scale}{Logical. Should data be scaled and centered?}

\item{method}{A character string specifying the method to be used for
correlation coefficients.}

\item{verbose}{Additional diagnostic messages.}
}
\value{
dendros    A list of dendrograms. For each fully separate part of the
  network an individual dendrogram.

names    A vector of feature names.

colors    A vector of numeric color coding in matching order of names
  and module eigengene names (color = 3 -> variable in ME3).

MEs    Aggregated module measures (Module eigengenes).

var_explained    Proportion of variance explained per module
  eigengene
  per principal component (max n_pc principal components are listed).

rotation    Matrix of variable loadings divided by their singular
  values. datan %*% rotation = MEs (with datan potentially scaled)

filter    Filter-Matrix as generated by the nb_filter function.
}
\description{
The Netboost clustering is performed in three subsequent steps. First, a
filter of important edges in the network is calculated. Next, pairwise
distances are calculated. Last, clustering is performed. For details see
Schlosser et al. doi...
}
\examples{
data('tcga_aml_meth_rna_chr18',  package='netboost')
results <- netboost(datan=tcga_aml_meth_rna_chr18, stepno=20L,
   soft_power=3L, min_cluster_size=10L, n_pc=2, scale=TRUE,
   ME_diss_thres=0.25, qc_plot=TRUE)

}
