% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netboost.R
\name{nb_summary}
\alias{nb_summary}
\title{Summarize results from a forest. Plot trees together.}
\usage{
nb_summary(clust_res)
}
\arguments{
\item{clust_res}{Clustering results from cut_trees call.}
}
\value{
List
}
\description{
Summarize results from a forest. Plot trees together.
}
\examples{
data('tcga_aml_meth_rna_chr18',  package='netboost')
 cores <- as.integer(getOption('mc.cores', 2))
 datan <- as.data.frame(scale(tcga_aml_meth_rna_chr18, center=TRUE,
 scale=TRUE))
 filter <- nb_filter(datan=datan, stepno=20L, until=0L, progress=1000L,
 cores=cores,mode=2L)
 dist <- nb_dist(datan=datan, filter=filter, soft_power=3L, cores=cores)
 max_singleton = dim(tcga_aml_meth_rna_chr18)[2]
 forest <- nb_mcupgma(filter=filter,dist=dist,max_singleton=max_singleton,
 cores=cores)
 trees <- tree_search(forest)
 results <- cut_trees(trees=trees,datan=datan, forest=forest,
 min_cluster_size=10L, ME_diss_thres=0.25, qc_plot=FALSE)
 sum_res <- nb_summary(clust_res=results)

}
