% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nempi_main.r
\name{nempi}
\alias{nempi}
\title{Main function for NEM based perturbation imputation.}
\usage{
nempi(
  D,
  unknown = "",
  Gamma = NULL,
  type = "null",
  full = TRUE,
  verbose = FALSE,
  logtype = 2,
  null = TRUE,
  soft = TRUE,
  combi = 1,
  converged = 0.1,
  complete = TRUE,
  mw = NULL,
  max_iter = 100,
  keepphi = TRUE,
  start = NULL,
  phi = NULL,
  ...
)
}
\arguments{
\item{D}{either a binary effects matrix or log odds matrix as
for Nested Effects Models (see package 'nem')}

\item{unknown}{colname of samples without mutation data, E.g. ""}

\item{Gamma}{matrix with expectations of perturbations, e.g. if you
have a binary mutation matrix, just normalize the columns to have sum 1}

\item{type}{"null": does not use the unknown samples for inference
at the start, "random" uses them in a random fashion (not recommended)}

\item{full}{if FALSE, does not change the known profiles}

\item{verbose}{if TRUE gives more output during inference}

\item{logtype}{log type for the log odds}

\item{null}{if FALSE does not use a NULL node for uninformative samples}

\item{soft}{if FALSE discretizes Gamma during the inference}

\item{combi}{if combi > 1, uses a more complex algorithm to infer
combinatorial perturbations (experimental)}

\item{converged}{the absolute difference of log likelihood till convergence}

\item{complete}{if TRUE uses the complete-data
logliklihood (recommended for many E-genes)}

\item{mw}{if NULL infers mixture weights, otherwise keeps them fixed}

\item{max_iter}{maximum iterations of the EM algorithm}

\item{keepphi}{if TRUE, uses the previous phi for the next inference,
if FALSE always starts with start network (and empty and full)}

\item{start}{starting network as adjacency matrix}

\item{phi}{if not NULL uses only this phi and does not infer a new one}

\item{...}{additional parameters for the nem
function (see package mnem, function nem or mnem::nem)}
}
\value{
nempi object
}
\description{
Infers perturbations profiles based on a sparse perturbation
matrix and differential gene expression as log odds
}
\examples{
D <- matrix(rnorm(1000*100), 1000, 100)
colnames(D) <- sample(seq_len(5), 100, replace = TRUE)
Gamma <- matrix(sample(c(0,1), 5*100, replace = TRUE, p = c(0.9, 0.1)), 5,
100)
Gamma <- apply(Gamma, 2, function(x) return(x/sum(x)))
Gamma[is.na(Gamma)] <- 0
rownames(Gamma) <- seq_len(5)
result <- nempi(D, Gamma = Gamma)
}
\author{
Martin Pirkl
}
