% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_user_get_networksummary}
\alias{ndex_user_get_networksummary}
\title{Get User's Account Page Networks}
\usage{
ndex_user_get_networksummary(ndexcon, userId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userId}{character; unique ID (UUID) of the user}
}
\value{
data.frame of networks (name, description, externalId, uri, etc.) on the account page of the specified user
}
\description{
This is a convenience function designed to support "My Account" pages in NDEx applications. 
It returns a list of NetworkSummary objects to display.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$networksummary
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## get user by name to get UUID
# user = ndex_find_user_byName(ndexcon, 'MyAccountName')
# userId = user$externalId
## get all network permissions of the user
# networkSummary = ndex_user_get_networksummary(con, user$externalId)
# names(networkSummary)
## [1] "ownerUUID"    "isReadOnly"  "subnetworkIds"  "errorMessage"      "isValid"         
## [6] "warnings"     "isShowcase"  "visibility"     "edgeCount"         "nodeCount"       
##[11] "uri"          "version"     "owner"          "name"              "properties"      
##[16] "description"  "externalId"  "isDeleted"      "modificationTime"  "creationTime"
NULL
}
