% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_aspects_and_metadata.r
\name{ndex_network_get_aspect}
\alias{ndex_network_get_aspect}
\title{Get a Network Aspect As CX}
\usage{
ndex_network_get_aspect(ndexcon, networkId, aspect, size)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{character; unique ID of the network}

\item{aspect}{character; name of the aspect}

\item{size}{integer; specifies the number of elements returned}
}
\value{
data.frame of the aspect data (the same as rcx[[aspectName]])
}
\description{
This function retrieves the provided aspect as CX. The result is the same as accessing an aspect of a RCX object.
}
\details{
\strong{Note: In future `ndexr` uses the \link[RCX]{RCX-object} from the corresponding package to handle the networks!}
}
\note{
Compatible to NDEx server version 1.3 and 2.0, but doesn't work for version 1.3
}
\section{REST query}{

GET: ndex_config$api$network$aspect$getMetaDataByName
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## Find a network and get its UUID
networks = ndex_find_networks(ndexcon,"p53", "nci-pid")
networkId = networks[1,"externalId"]
## Get the aspect of a network
aspect = ndex_network_get_aspect(ndexcon, networkId, 'nodeAttributes')
# limit the returned elements of the aspect to the first 10 elements
aspect = ndex_network_get_aspect(ndexcon, networkId, 'nodeAttributes', 10)
}
