% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfFlowSet-rbind-methods.R
\name{rbind2,ncdfFlowList,ANY-method}
\alias{rbind2,ncdfFlowList,ANY-method}
\title{combine multiple ncdfFlowSet objects into one}
\usage{
\S4method{rbind2}{ncdfFlowList,ANY}(
  x,
  ncdfFile = tempfile(pattern = "ncfs"),
  dim = 2,
  compress = 0,
  samples = NULL
)
}
\arguments{
\item{x}{\code{ncdfFlowList}}

\item{ncdfFile}{\code{character} see details in \link{read.ncdfFlowset}
when all the ncdfFlowSets shared the same cdf file, by supplying this argument, it will use the existing cdf and avoid writing to it unneccessarily.}

\item{dim}{\code{integer} see details in \link{read.ncdfFlowset}.}

\item{compress}{\code{integer} see details in \link{read.ncdfFlowset}.}

\item{samples}{\code{character} the vector of sample names which determine the physical sample storage order in original cdf file. 
Default is NULL, which derives from the given ncdfFlowSet objects.}
}
\value{
a new ncdfFlowSet with a new cdf file that combines multiple raw datasets.
}
\description{
Similar to \code{\link[=rbind2,flowSet,flowSet-method]{flowCore:rbind2}}. 
But one needs to first construct a ncdfFlowList and then apply rbind2 to it instead of merging them pairwise
}
\examples{
library(ncdfFlow)
data(GvHD)

nc1 <- ncdfFlowSet(GvHD[1:2])
nc2 <- ncdfFlowSet(GvHD[3:4])
nc3 <- ncdfFlowSet(GvHD[5:6])
ncfslist <- ncdfFlowList(list(nc1,nc2,nc3))
nc4 <- rbind2(ncfslist)
nc4
}
