% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfFlowSet-accessors.R
\name{ncfsApply,ncdfFlowSet-method}
\alias{ncfsApply,ncdfFlowSet-method}
\alias{ncfsApply}
\title{apply method for ncdfFlowSet (for internal use)}
\usage{
\S4method{ncfsApply}{ncdfFlowSet}(x, FUN, ..., use.exprs = FALSE, ncdfFile = NULL)
}
\arguments{
\item{x}{\code{ncdfFlowSet}}

\item{FUN}{\code{function} to apply}

\item{...}{other arguments to pass to \code{FUN}}

\item{use.exprs}{\code{logical} see \code{\link{fsApply}}}

\item{ncdfFile}{A character scalar giving the output file name. By
default, It is NULL and the function will generate a random
file name, potentially adding the \code{.cdf} suffix unless a file
extension is already present.}
}
\description{
It is equivalent to \code{\link{fsApply}}. But the latter could cause memory issue 
when \code{FUN} returns a \code{flowFrame}. \code{ncfsApply} writes to a new cdf file instead of memory. 
Thus it will return a ncdfFlowSet object.
}
\details{
When the function given by argument "FUN" does not return the entire flowFrame object with the same 
size of the original one (such as compensate,transform...), \code{\link[flowCore:fsApply]{fsApply}} should be used instead.
}
\examples{
data(GvHD)
nc <- ncdfFlowSet(GvHD[1:2])

#use fsApply when FUN does not return a flowFrame 
fsApply(nc, nrow)
fsApply(nc, range)

#use ncfsApply when FUN returns a flowFrame
lgcl <- logicleTransform( w = 0.5, t= 10000, m =4.5)
translist <- transformList(c("FL1-H", "FL2-H"), lgcl)
nc1 <- ncfsApply(nc, transform, translist)
}
