# Contributing to `mzR`

We welcome contributions from everybody, including bug fixes, new
features, improvements on the documentation, and general suggestions.

Here are some pieces of advice and suggestions:

* We recommend to discuss changes and contributions in a Github issue,
 in particular when these are substantial.

* Check in the
 current [Github issues](https://github.com/sneumann/mzR/issues) to
 see if a similar issue is already discussed, and join efforts.

* Make the updates as small and contained as possible, possibly under
 different Github commits, to facilitate the code review. Don't
 hesitate to use the Github code review.

* Follow the coding style used in the package. See also the
  Bioconductor coding
  style
  [here](https://bioconductor.org/developers/how-to/coding-style/).

* Ideally, add a unit test that checks the new code, examples are in
  `mzR/inst/unitTests`.

* Please avoid platform specific code to assure that `mzR` builds and
  checks Linux, Windows and OSX. Pull requests will also be checked by
  https://travis-ci.org/sneumann/mzR/

* Make sure to also update the documentation (man pages and/or
  vignette) to make sure users are aware of the changes.

* If your change is visible to users (new features, bug fix, updated
  documentation, ...) update the `NEWS` file.

Before sending a pull request, we advice to discuss the changes in a
Github issue, in particular when these are substantial.

### Contributor Code of Conduct

As contributors and maintainers of this project, we pledge to respect
all people who contribute through reporting issues, posting feature
requests, updating documentation, submitting pull requests or patches,
and other activities.

We are committed to making participation in this project a
harassment-free experience for everyone, regardless of level of
experience, gender, gender identity and expression, sexual
orientation, disability, personal appearance, body size, race,
ethnicity, age, or religion.

Examples of unacceptable behaviour by participants include the use of
sexual language or imagery, derogatory comments or personal attacks,
trolling, public or private harassment, insults, or other
unprofessional conduct.

Project maintainers have the right and responsibility to remove, edit,
or reject comments, commits, code, wiki edits, issues, and other
contributions that are not aligned to this Code of Conduct. Project
maintainers who do not follow the Code of Conduct may be removed from
the project team.

Instances of abusive, harassing, or otherwise unacceptable behaviour
may be reported by opening an issue or contacting one or more of the
project maintainers.

This Code of Conduct is adapted from the Contributor Covenant, version
1.0.0, available from http://contributor-covenant.org/version/1/0/0/
